/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBUpdate;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBUpdateLargeObjects
extends DBUpdate {
    private static final Log log = LogFactory.getLog(DBUpdateLargeObjects.class);

    protected DBUpdateLargeObjects(DBRow row) {
        super(row);
    }

    @Override
    protected DBActionList execute(DBDatabase db) throws SQLException {
        DBRow row = this.getRow();
        DBActionList actions = new DBActionList(new DBAction[0]);
        DBDefinition defn = db.getDefinition();
        DBStatement statement = db.getDBStatement();
        try {
            actions = new DBActionList(new DBAction[0]);
            for (PropertyWrapper prop : this.getInterestingLargeObjects(row)) {
                String col = prop.columnName();
                DBLargeObject largeObject = (DBLargeObject)prop.getQueryableDatatype();
                if (defn.prefersLargeObjectsSetAsCharacterStream()) {
                    this.setUsingCharacterStream(defn, row, col, largeObject, db, statement);
                } else if (defn.prefersLargeObjectsSetAsBase64String()) {
                    this.setUsingBase64String(defn, row, col, largeObject, db, statement);
                } else {
                    this.setUsingBinaryStream(defn, row, col, largeObject, db, statement);
                }
                DBUpdateLargeObjects update = new DBUpdateLargeObjects(row);
                actions.add(update);
                largeObject.setUnchanged();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DBUpdateLargeObjects.class.getName()).log(Level.SEVERE, null, ex);
            throw new DBRuntimeException("Can't Set LargeObject: IOError", ex);
        }
        finally {
            statement.close();
        }
        return actions;
    }

    private void setUsingStringValue(DBDefinition defn, DBRow row, String col, DBLargeObject largeObject, DBDatabase db, DBStatement statement) throws SQLException {
        String sqlString = defn.beginUpdateLine() + defn.formatTableName(row) + defn.beginSetClause() + defn.formatColumnName(col) + defn.getEqualsComparator() + "'" + largeObject.stringValue() + "'" + defn.beginWhereClause() + defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + ((QueryableDatatype)row.getPrimaryKey()).toSQLString(db) + defn.endSQLStatement();
        log.info((Object)sqlString);
        statement.execute(sqlString);
    }

    private void setUsingBinaryStream(DBDefinition defn, DBRow row, String col, DBLargeObject largeObject, DBDatabase db, DBStatement statement) throws SQLException {
        String sqlString = defn.beginUpdateLine() + defn.formatTableName(row) + defn.beginSetClause() + defn.formatColumnName(col) + defn.getEqualsComparator() + defn.getPreparedVariableSymbol() + defn.beginWhereClause() + defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + ((QueryableDatatype)row.getPrimaryKey()).toSQLString(db) + defn.endSQLStatement();
        log.info((Object)sqlString);
        PreparedStatement prep = statement.getConnection().prepareStatement(sqlString);
        prep.setBinaryStream(1, largeObject.getInputStream(), largeObject.getSize());
        prep.execute();
    }

    private void setUsingBase64String(DBDefinition defn, DBRow row, String col, DBLargeObject largeObject, DBDatabase db, DBStatement statement) throws SQLException, IOException {
        String sqlString = defn.beginUpdateLine() + defn.formatTableName(row) + defn.beginSetClause() + defn.formatColumnName(col) + defn.getEqualsComparator() + defn.getPreparedVariableSymbol() + defn.beginWhereClause() + defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + ((QueryableDatatype)row.getPrimaryKey()).toSQLString(db) + defn.endSQLStatement();
        log.info((Object)sqlString);
        PreparedStatement prep = statement.getConnection().prepareStatement(sqlString);
        InputStream inputStream = largeObject.getInputStream();
        BufferedInputStream input = new BufferedInputStream(inputStream);
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        int totalBytesRead = 0;
        byte[] resultSetBytes = new byte[100000];
        int bytesRead = ((InputStream)input).read(resultSetBytes);
        while (bytesRead > 0) {
            totalBytesRead += bytesRead;
            byteArrays.add(resultSetBytes);
            resultSetBytes = new byte[100000];
            bytesRead = ((InputStream)input).read(resultSetBytes);
        }
        byte[] bytes = new byte[totalBytesRead];
        int bytesAdded = 0;
        for (byte[] someBytes : byteArrays) {
            System.arraycopy(someBytes, 0, bytes, bytesAdded, Math.min(someBytes.length, bytes.length - bytesAdded));
            bytesAdded += someBytes.length;
        }
        String b64encoded = Base64.encodeBase64String((byte[])bytes);
        System.out.println("BYTES TO WRITE: " + Arrays.toString(bytes));
        prep.setString(1, b64encoded);
        prep.execute();
    }

    private void setUsingCharacterStream(DBDefinition defn, DBRow row, String col, DBLargeObject largeObject, DBDatabase db, DBStatement statement) throws SQLException {
        String sqlString = defn.beginUpdateLine() + defn.formatTableName(row) + defn.beginSetClause() + defn.formatColumnName(col) + defn.getEqualsComparator() + defn.getPreparedVariableSymbol() + defn.beginWhereClause() + defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + ((QueryableDatatype)row.getPrimaryKey()).toSQLString(db) + defn.endSQLStatement();
        log.info((Object)sqlString);
        PreparedStatement prep = statement.getConnection().prepareStatement(sqlString);
        prep.setCharacterStream(1, new InputStreamReader(largeObject.getInputStream()));
        prep.execute();
    }

    @Override
    public List<String> getSQLStatements(DBDatabase db) {
        DBRow row = this.getRow();
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(db.getDefinition().startMultilineComment() + " SAVE BINARY DATA" + db.getDefinition().endMultilineComment());
        return strs;
    }

    protected List<PropertyWrapper> getInterestingLargeObjects(DBRow row) {
        return this.getChangedLargeObjects(row);
    }

    @Override
    protected DBActionList getRevertDBActionList() {
        return new DBActionList(new DBAction[0]);
    }

    @Override
    protected DBActionList getActions() {
        return new DBActionList(new DBUpdateLargeObjects(this.getRow()));
    }

    private List<PropertyWrapper> getChangedLargeObjects(DBRow row) {
        ArrayList<PropertyWrapper> changed = new ArrayList<PropertyWrapper>();
        if (row.hasLargeObjects()) {
            for (QueryableDatatype qdt : row.getLargeObjects()) {
                DBLargeObject large;
                if (!(qdt instanceof DBLargeObject) || !(large = (DBLargeObject)qdt).hasChanged()) continue;
                changed.add(row.getPropertyWrapperOf(qdt));
            }
        }
        return changed;
    }
}

