/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBUpdateLargeObjects;
import nz.co.gregs.dbvolution.actions.DBUpdateSimpleTypes;
import nz.co.gregs.dbvolution.actions.DBUpdateSimpleTypesUsingAllColumns;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.AccidentalUpdateOfUndefinedRowException;

public abstract class DBUpdate
extends DBAction {
    public <R extends DBRow> DBUpdate(R row) {
        super(row);
    }

    public static DBActionList update(DBDatabase db, DBRow row) throws SQLException {
        DBActionList updates = DBUpdate.getUpdates(row);
        for (DBAction act : updates) {
            act.execute(db);
        }
        return updates;
    }

    public static DBActionList update(DBRow ... rows) throws SQLException {
        return DBUpdate.getUpdates(rows);
    }

    public static DBActionList getUpdates(DBRow ... rows) throws SQLException {
        DBActionList updates = new DBActionList(new DBAction[0]);
        for (DBRow row : rows) {
            if (row.getDefined()) {
                if (row.hasChangedSimpleTypes()) {
                    if (row.getPrimaryKey() == null) {
                        updates.add(new DBUpdateSimpleTypesUsingAllColumns(row));
                    } else {
                        updates.add(new DBUpdateSimpleTypes(row));
                    }
                }
                if (!DBUpdate.hasChangedLargeObjects(row)) continue;
                updates.add(new DBUpdateLargeObjects(row));
                continue;
            }
            throw new AccidentalUpdateOfUndefinedRowException(row);
        }
        return updates;
    }

    private static boolean hasChangedLargeObjects(DBRow row) {
        if (row.hasLargeObjects()) {
            for (QueryableDatatype qdt : row.getLargeObjects()) {
                if (!qdt.hasChanged()) continue;
                return true;
            }
        }
        return false;
    }
}

