/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDeleteByPrimaryKey;
import nz.co.gregs.dbvolution.actions.DBDeleteUsingAllColumns;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBInsert
extends DBAction {
    private static final Log log = LogFactory.getLog(DBInsert.class);
    private transient StringBuilder allColumns;
    private transient StringBuilder allValues;
    private final List<Long> generatedKeys = new ArrayList<Long>();
    private final DBRow originalRow;

    protected <R extends DBRow> DBInsert(R row) {
        super(row);
        this.originalRow = row;
    }

    public static DBActionList save(DBDatabase database, DBRow row) throws SQLException {
        DBInsert dbInsert = new DBInsert(row);
        DBActionList executedActions = dbInsert.execute(database);
        if (dbInsert.generatedKeys.size() == 1 && !((QueryableDatatype)row.getPrimaryKey()).hasBeenSet()) {
            ((QueryableDatatype)row.getPrimaryKey()).setValue(dbInsert.generatedKeys.get(0));
        }
        return executedActions;
    }

    public ArrayList<String> getSQLStatements(DBDatabase db) {
        DBRow row = this.getRow();
        DBDefinition defn = db.getDefinition();
        this.processAllFieldsForInsert(db, row);
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(defn.beginInsertLine() + defn.formatTableName(row) + defn.beginInsertColumnList() + this.allColumns + defn.endInsertColumnList() + this.allValues + defn.beginReturningClause(row) + defn.endInsertLine());
        return strs;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected DBActionList execute(DBDatabase db) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processAllFieldsForInsert(DBDatabase database, DBRow row) {
        this.allColumns = new StringBuilder();
        this.allValues = new StringBuilder();
        DBDefinition defn = database.getDefinition();
        List<PropertyWrapper> props = row.getPropertyWrappers();
        String columnSeparator = "";
        String valuesSeparator = defn.beginValueClause();
        for (PropertyWrapper prop : props) {
            Object qdt;
            if (!prop.isColumn() || (qdt = prop.getQueryableDatatype()) instanceof DBLargeObject || !((QueryableDatatype)qdt).hasBeenSet()) continue;
            this.allColumns.append(columnSeparator).append(" ").append(defn.formatColumnName(prop.columnName()));
            columnSeparator = defn.getValuesClauseColumnSeparator();
            this.allValues.append(valuesSeparator).append(((QueryableDatatype)qdt).toSQLString(database));
            valuesSeparator = defn.getValuesClauseValueSeparator();
        }
        this.allValues.append(defn.endValueClause());
    }

    @Override
    protected DBActionList getRevertDBActionList() {
        DBActionList reverts = new DBActionList(new DBAction[0]);
        if (this.getRow().getPrimaryKey() == null) {
            reverts.add(new DBDeleteUsingAllColumns(this.getRow()));
        } else {
            reverts.add(new DBDeleteByPrimaryKey(this.getRow()));
        }
        return reverts;
    }

    @Override
    protected DBActionList getActions() {
        return new DBActionList(new DBInsert(this.getRow()));
    }

    public static DBActionList getInserts(DBRow ... rows) throws SQLException {
        DBActionList inserts = new DBActionList(new DBAction[0]);
        for (DBRow row : rows) {
            inserts.add(new DBInsert(row));
        }
        return inserts;
    }

    public List<Long> getGeneratedPrimaryKeys() {
        return this.generatedKeys;
    }
}

