/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDelete;
import nz.co.gregs.dbvolution.actions.DBInsert;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;

public class DBDeleteUsingAllColumns
extends DBDelete {
    private List<DBRow> savedRows = new ArrayList<DBRow>();

    protected <R extends DBRow> DBDeleteUsingAllColumns(R row) {
        super(row);
    }

    private <R extends DBRow> DBDeleteUsingAllColumns(DBDatabase db, R row) throws SQLException {
        super(row);
        List<R> gotRows = db.get(row);
        for (R gotRow : gotRows) {
            this.savedRows.add(gotRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBActionList execute(DBDatabase db) throws SQLException {
        DBRow row = this.getRow();
        DBActionList actions = new DBActionList(new DBDeleteUsingAllColumns(row));
        DBStatement statement = db.getDBStatement();
        try {
            List<DBRow> rowsToBeDeleted = db.get(row);
            for (DBRow deletingRow : rowsToBeDeleted) {
                this.savedRows.add(DBRow.copyDBRow(deletingRow));
            }
            for (String str : this.getSQLStatements(db)) {
                statement.execute(str);
            }
        }
        finally {
            statement.close();
        }
        return actions;
    }

    public ArrayList<String> getSQLStatements(DBDatabase db) {
        DBRow row = this.getRow();
        DBDefinition defn = db.getDefinition();
        String sql = defn.beginDeleteLine() + defn.formatTableName(row) + defn.beginWhereClause() + defn.getWhereClauseBeginningCondition();
        for (PropertyWrapper prop : row.getPropertyWrappers()) {
            Object qdt = prop.getQueryableDatatype();
            sql = sql + defn.beginWhereClauseLine() + prop.columnName() + defn.getEqualsComparator() + (((QueryableDatatype)qdt).hasChanged() ? ((QueryableDatatype)qdt).getPreviousSQLValue(db) : ((QueryableDatatype)qdt).toSQLString(db));
        }
        sql = sql + defn.endDeleteLine();
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(sql);
        return strs;
    }

    @Override
    protected DBActionList getRevertDBActionList() {
        DBActionList reverts = new DBActionList(new DBAction[0]);
        for (DBRow savedRow : this.savedRows) {
            reverts.add(new DBInsert(savedRow));
        }
        return reverts;
    }

    @Override
    protected DBActionList getActions() {
        return new DBActionList(new DBDeleteUsingAllColumns(this.getRow()));
    }

    @Override
    protected DBActionList getActions(DBDatabase db, DBRow row) throws SQLException {
        return new DBActionList(new DBDeleteUsingAllColumns(db, row));
    }
}

