/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDelete;
import nz.co.gregs.dbvolution.actions.DBInsert;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;

public class DBDeleteByPrimaryKey
extends DBDelete {
    private final List<DBRow> savedRows = new ArrayList<DBRow>();

    protected <R extends DBRow> DBDeleteByPrimaryKey(R row) {
        super(row);
    }

    private <R extends DBRow> DBDeleteByPrimaryKey(DBDatabase db, R row) throws SQLException {
        super(row);
        Object example = DBRow.getDBRow(row.getClass());
        ((QueryableDatatype)((DBRow)example).getPrimaryKey()).setValue(row.getPrimaryKey());
        List<?> gotRows = db.get(example);
        for (DBRow gotRow : gotRows) {
            this.savedRows.add(gotRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DBActionList execute(DBDatabase db) throws SQLException {
        DBRow row = this.getRow();
        DBDeleteByPrimaryKey newDeleteAction = new DBDeleteByPrimaryKey(row);
        DBActionList actions = new DBActionList(newDeleteAction);
        Object example = DBRow.getDBRow(row.getClass());
        ((QueryableDatatype)((DBRow)example).getPrimaryKey()).setValue(row.getPrimaryKey());
        List<?> rowsToBeDeleted = db.get(example);
        for (DBRow deletingRow : rowsToBeDeleted) {
            newDeleteAction.savedRows.add(DBRow.copyDBRow(deletingRow));
        }
        DBStatement statement = db.getDBStatement();
        try {
            for (String str : this.getSQLStatements(db)) {
                statement.execute(str);
            }
        }
        finally {
            statement.close();
        }
        return actions;
    }

    public ArrayList<String> getSQLStatements(DBDatabase db) {
        DBDefinition defn = db.getDefinition();
        DBRow row = this.getRow();
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(defn.beginDeleteLine() + defn.formatTableName(row) + defn.beginWhereClause() + defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + ((QueryableDatatype)row.getPrimaryKey()).toSQLString(db) + defn.endDeleteLine());
        return strs;
    }

    @Override
    protected DBActionList getRevertDBActionList() {
        DBActionList reverts = new DBActionList(new DBAction[0]);
        for (DBRow savedRow : this.savedRows) {
            reverts.add(new DBInsert(savedRow));
        }
        return reverts;
    }

    @Override
    protected DBActionList getActions() {
        return new DBActionList(new DBDeleteByPrimaryKey(this.getRow()));
    }

    @Override
    protected DBActionList getActions(DBDatabase db, DBRow row) throws SQLException {
        return new DBActionList(new DBDeleteByPrimaryKey(db, row));
    }
}

