/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDelete;
import nz.co.gregs.dbvolution.actions.DBInsert;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;

public class DBDeleteByExample
extends DBDelete {
    private List<DBRow> savedRows = new ArrayList<DBRow>();

    protected <R extends DBRow> DBDeleteByExample(R row) {
        super(row);
    }

    private <R extends DBRow> DBDeleteByExample(DBDatabase db, R row) throws SQLException {
        super(row);
        List<R> gotRows = db.get(row);
        for (R gotRow : gotRows) {
            this.savedRows.add(DBRow.copyDBRow(gotRow));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DBActionList execute(DBDatabase db) throws SQLException {
        DBRow row = this.getRow();
        DBDeleteByExample deleteAction = new DBDeleteByExample(row);
        DBActionList actions = new DBActionList(deleteAction);
        List<DBRow> rowsToBeDeleted = db.get(row);
        for (DBRow deletingRow : rowsToBeDeleted) {
            deleteAction.savedRows.add(DBRow.copyDBRow(deletingRow));
        }
        DBStatement statement = db.getDBStatement();
        try {
            for (String str : this.getSQLStatements(db)) {
                statement.execute(str);
            }
        }
        finally {
            statement.close();
        }
        return actions;
    }

    @Override
    public List<String> getSQLStatements(DBDatabase db) {
        DBRow row = this.getRow();
        DBDefinition defn = db.getDefinition();
        String whereClause = "";
        for (String clause : row.getWhereClausesWithoutAliases(db)) {
            whereClause = whereClause + defn.beginAndLine() + clause;
        }
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(defn.beginDeleteLine() + defn.formatTableName(row) + defn.beginWhereClause() + defn.getWhereClauseBeginningCondition() + whereClause + defn.endDeleteLine());
        return strs;
    }

    @Override
    protected DBActionList getRevertDBActionList() {
        DBActionList reverts = new DBActionList(new DBAction[0]);
        for (DBRow savedRow : this.savedRows) {
            reverts.add(new DBInsert(savedRow));
        }
        return reverts;
    }

    @Override
    protected DBActionList getActions() {
        return new DBActionList(new DBDeleteByExample(this.getRow()));
    }

    @Override
    protected DBActionList getActions(DBDatabase db, DBRow row) throws SQLException {
        return new DBActionList(new DBDeleteByExample(db, row));
    }
}

