/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.Collection;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDeleteByExample;
import nz.co.gregs.dbvolution.actions.DBDeleteByPrimaryKey;
import nz.co.gregs.dbvolution.actions.DBDeleteUsingAllColumns;

public abstract class DBDelete
extends DBAction {
    protected <R extends DBRow> DBDelete(R row) {
        super(row);
    }

    public static DBActionList delete(DBDatabase database, DBRow row) throws SQLException {
        DBActionList delete = DBDelete.getDeletes(database, row);
        return delete.execute(database);
    }

    public static DBActionList getDeletesWithRevertCapability(DBRow ... rows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (DBRow row : rows) {
            if (row.getDefined()) {
                if (row.getPrimaryKey() == null) {
                    DBDeleteUsingAllColumns allCols = new DBDeleteUsingAllColumns(row);
                    actions.addAll(allCols.getActions());
                    continue;
                }
                DBDeleteByPrimaryKey pk = new DBDeleteByPrimaryKey(row);
                actions.addAll(pk.getActions());
                continue;
            }
            DBDeleteByExample example = new DBDeleteByExample(row);
            actions.addAll(example.getActions());
        }
        return actions;
    }

    public static DBActionList getDeletes(DBDatabase db, DBRow ... rows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (DBRow row : rows) {
            if (row.getDefined()) {
                if (row.getPrimaryKey() == null) {
                    DBDeleteUsingAllColumns allCols = new DBDeleteUsingAllColumns(row);
                    actions.addAll(allCols.getActions(db, row));
                    continue;
                }
                DBDeleteByPrimaryKey pk = new DBDeleteByPrimaryKey(row);
                actions.addAll(pk.getActions(db, row));
                continue;
            }
            DBDeleteByExample example = new DBDeleteByExample(row);
            actions.addAll(example.getActions(db, row));
        }
        return actions;
    }

    public static DBActionList getDeletes(DBDatabase db, Collection<? extends DBRow> rows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (DBRow dBRow : rows) {
            if (dBRow.getDefined()) {
                if (dBRow.getPrimaryKey() == null) {
                    DBDeleteUsingAllColumns allCols = new DBDeleteUsingAllColumns(dBRow);
                    actions.addAll(allCols.getActions(db, dBRow));
                    continue;
                }
                DBDeleteByPrimaryKey pk = new DBDeleteByPrimaryKey(dBRow);
                actions.addAll(pk.getActions(db, dBRow));
                continue;
            }
            DBDeleteByExample example = new DBDeleteByExample(dBRow);
            actions.addAll(example.getActions(db, dBRow));
        }
        return actions;
    }

    protected abstract DBActionList getActions(DBDatabase var1, DBRow var2) throws SQLException;
}

