/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.actions.DBAction;

public class DBActionList
extends ArrayList<DBAction> {
    private static final long serialVersionUID = 1L;

    public DBActionList(DBAction ... actions) {
        this.addAll(Arrays.asList(actions));
    }

    public synchronized List<String> getSQL(DBDatabase db) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (DBAction act : this) {
            sqlList.addAll(act.getSQLStatements(db));
        }
        return sqlList;
    }

    public synchronized DBActionList execute(DBDatabase database) throws SQLException {
        DBActionList executed = new DBActionList(new DBAction[0]);
        for (DBAction action : this) {
            executed.addAll(action.execute(database));
        }
        return executed;
    }

    public DBActionList getRevertActionList() {
        DBAction[] toArray = this.toArray(new DBAction[0]);
        DBActionList reverts = new DBActionList(new DBAction[0]);
        for (int i = toArray.length - 1; i >= 0; --i) {
            reverts.addAll(toArray[i].getRevertDBActionList());
        }
        return reverts;
    }
}

