/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution;

import java.io.PrintStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDelete;
import nz.co.gregs.dbvolution.actions.DBInsert;
import nz.co.gregs.dbvolution.actions.DBUpdate;
import nz.co.gregs.dbvolution.annotations.DBSelectQuery;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.AccidentalBlankQueryException;
import nz.co.gregs.dbvolution.exceptions.IncorrectRowProviderInstanceSuppliedException;
import nz.co.gregs.dbvolution.exceptions.UndefinedPrimaryKeyException;
import nz.co.gregs.dbvolution.exceptions.UnexpectedNumberOfRowsException;
import nz.co.gregs.dbvolution.exceptions.UnknownJavaSQLTypeException;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.query.RowDefinition;

@Deprecated
public class DBTableOLD<E extends DBRow> {
    E template;
    private DBDatabase database = null;
    ResultSet resultSet = null;
    private final ArrayList<E> listOfRows = new ArrayList();
    private Long rowLimit;
    private List<PropertyWrapper> sortOrder = null;
    private boolean blankQueryAllowed = false;
    private final QueryOptions options = new QueryOptions();

    public static <E extends DBRow> DBTableOLD<E> getInstance(DBDatabase database, E example) {
        DBTableOLD<E> dbTable = new DBTableOLD<E>(database, example);
        return dbTable;
    }

    private DBTableOLD(DBDatabase myDatabase, E dummyObject) {
        this.database = myDatabase;
        this.template = dummyObject;
    }

    private String getAllFieldsForSelect() {
        StringBuilder allFields = new StringBuilder();
        List<String> columnNames = ((DBRow)this.template).getColumnNames(this.database);
        String separator = "";
        for (String column : columnNames) {
            allFields.append(separator).append(" ").append(this.database.getDefinition().formatColumnName(column));
            separator = ",";
        }
        return allFields.toString();
    }

    private String getSQLForSelectAll() {
        DBDefinition defn = this.database.getDefinition();
        StringBuilder selectStatement = new StringBuilder();
        DBSelectQuery selectQueryAnnotation = this.template.getClass().getAnnotation(DBSelectQuery.class);
        if (selectQueryAnnotation != null) {
            selectStatement.append(selectQueryAnnotation.value());
        } else {
            selectStatement.append(defn.beginSelectStatement());
            if (this.rowLimit != null) {
                selectStatement.append(defn.getLimitRowsSubClauseDuringSelectClause(this.options));
            }
            selectStatement.append(this.getAllFieldsForSelect()).append(defn.beginFromClause()).append(defn.formatTableName((DBRow)this.template)).append(defn.beginTableAlias()).append(defn.getTableAlias((RowDefinition)this.template)).append(defn.endTableAlias()).append(this.getOrderByClause()).append(defn.getLimitRowsSubClauseAfterWhereClause(this.options)).append(defn.endSQLStatement());
        }
        return selectStatement.toString();
    }

    @Deprecated
    public String getSQLForSelect() {
        return this.getSQLSelectAndFromForQuery();
    }

    public String getSQLSelectAndFromForQuery() {
        DBDefinition defn = this.database.getDefinition();
        StringBuilder selectStatement = new StringBuilder();
        DBSelectQuery selectQueryAnnotation = this.template.getClass().getAnnotation(DBSelectQuery.class);
        if (selectQueryAnnotation != null) {
            selectStatement.append(selectQueryAnnotation.value()).append(defn.beginWhereClause()).append(defn.getWhereClauseBeginningCondition(this.options));
        } else {
            selectStatement.append(defn.beginSelectStatement());
            if (this.rowLimit != null) {
                selectStatement.append(defn.getLimitRowsSubClauseDuringSelectClause(this.options));
            }
            selectStatement.append(this.getAllFieldsForSelect()).append(defn.beginFromClause()).append(defn.formatTableName((DBRow)this.template)).append(defn.beginWhereClause()).append(defn.getWhereClauseBeginningCondition(this.options));
        }
        return selectStatement.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTableOLD<E> getAllRows() throws SQLException, AccidentalBlankQueryException {
        if (!this.blankQueryAllowed) {
            throw new AccidentalBlankQueryException();
        }
        this.resultSet = null;
        this.listOfRows.clear();
        String selectStatement = this.getSQLForSelectAll();
        this.resultSet = null;
        DBStatement statement = this.database.getDBStatement();
        try {
            try {
                try {
                    boolean executed = statement.execute(selectStatement);
                }
                catch (SQLException noConnection) {
                    throw new RuntimeException("Unable to create a Statement: please check the database URL, username, and password, and that the appropriate libaries have been supplied: URL=" + this.database.getJdbcURL() + " USERNAME=" + this.database.getUsername(), noConnection);
                }
                try {
                    this.resultSet = statement.getResultSet();
                }
                catch (SQLException noConnection) {
                    throw new RuntimeException("Unable to create a Statement: please check the database URL, username, and password, and that the appropriate libaries have been supplied: URL=" + this.database.getJdbcURL() + " USERNAME=" + this.database.getUsername(), noConnection);
                }
                this.addAllFields(this, this.resultSet);
            }
            finally {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
        }
        finally {
            statement.close();
        }
        return this;
    }

    private void addAllFields(DBTableOLD<E> dbTable, ResultSet resultSet) throws SQLException {
        DBDefinition defn = this.database.getDefinition();
        ResultSetMetaData rsMeta = resultSet.getMetaData();
        HashMap<String, Integer> dbColumnNames = new HashMap<String, Integer>();
        for (int k = 1; k <= rsMeta.getColumnCount(); ++k) {
            dbColumnNames.put(defn.formatColumnName(rsMeta.getColumnName(k)), k);
        }
        while (resultSet.next()) {
            Object tableRow = DBRow.getDBRow(this.template.getClass());
            List<PropertyWrapper> fields = ((RowDefinition)tableRow).getPropertyWrappers();
            for (PropertyWrapper field : fields) {
                if (!field.isColumn()) continue;
                String dbColumnName = field.columnName();
                String formattedColumnName = defn.formatColumnName(dbColumnName);
                Integer dbColumnIndex = (Integer)dbColumnNames.get(formattedColumnName);
                if (formattedColumnName == null || dbColumnIndex == null) continue;
                this.setObjectFieldValueToColumnValue(rsMeta, dbColumnIndex, field, (DBRow)tableRow, resultSet, dbColumnName);
                Object qdt = field.getQueryableDatatype();
                if (!((DBRow)tableRow).isEmptyRow().booleanValue() || ((QueryableDatatype)qdt).isNull()) continue;
                ((DBRow)tableRow).setEmptyRow(false);
            }
            ((DBRow)tableRow).setDefined();
            dbTable.listOfRows.add(tableRow);
        }
    }

    private void setObjectFieldValueToColumnValue(ResultSetMetaData rsMeta, int dbColumnIndex, PropertyWrapper field, DBRow tableRow, ResultSet resultSet, String dbColumnName) throws SQLException {
        Object qdt = field.getQueryableDatatype();
        int columnType = rsMeta.getColumnType(dbColumnIndex);
        switch (columnType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -7: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: 
            case 2011: {
                ((QueryableDatatype)qdt).setFromResultSet(this.database, resultSet, dbColumnName);
                field.setQueryableDatatype((QueryableDatatype)qdt);
                break;
            }
            default: {
                throw new UnknownJavaSQLTypeException("Unknown Java SQL Type: table " + tableRow.getTableName() + " column " + dbColumnName + " has a Unknown SQL type of " + rsMeta.getColumnType(dbColumnIndex) + ". Please contact enquiry at https://sourceforge.net/projects/dbvolution/ for support.", rsMeta.getColumnType(dbColumnIndex));
            }
        }
    }

    private String getPrimaryKeyColumnName() {
        String columnName = ((DBRow)this.template).getPrimaryKeyColumnName();
        if (columnName == null) {
            throw new UndefinedPrimaryKeyException(this.template.getClass());
        }
        return columnName;
    }

    private String escapeSingleQuotes(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("'", "''").replace("\\", "\\\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBTableOLD<E> getRows(String selectStatement) throws SQLException {
        this.listOfRows.clear();
        DBStatement statement = this.database.getDBStatement();
        try {
            boolean executed = statement.execute(selectStatement);
            this.resultSet = statement.getResultSet();
            try {
                this.addAllFields(this, this.resultSet);
            }
            finally {
                this.resultSet.close();
            }
        }
        finally {
            statement.close();
        }
        return this;
    }

    public DBTableOLD<E> getRowsByPrimaryKey(Object pkValue) throws SQLException {
        DBDefinition defn = this.database.getDefinition();
        String whereClause = defn.beginConditionClauseLine(this.options) + defn.formatColumnName(this.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + " '" + this.escapeSingleQuotes(pkValue.toString()) + "'";
        String selectStatement = this.getSQLSelectAndFromForQuery() + whereClause + this.getOrderByClause() + this.database.getDefinition().endSQLStatement();
        this.getRows(selectStatement);
        return this;
    }

    public DBTableOLD<E> getRowsByPrimaryKey(Number pkValue) throws SQLException {
        DBDefinition defn = this.database.getDefinition();
        String whereClause = defn.beginConditionClauseLine(this.options) + defn.formatColumnName(this.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + pkValue + " ";
        String selectStatement = this.getSQLSelectAndFromForQuery() + whereClause + this.getOrderByClause() + this.database.getDefinition().endSQLStatement();
        this.getRows(selectStatement);
        return this;
    }

    public DBTableOLD<E> getRowsByPrimaryKey(Date pkValue) throws SQLException {
        DBDefinition defn = this.database.getDefinition();
        String whereClause = defn.beginConditionClauseLine(this.options) + defn.formatColumnName(this.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + defn.getDateFormattedForQuery(pkValue) + " ";
        String selectStatement = this.getSQLSelectAndFromForQuery() + whereClause + this.getOrderByClause() + this.database.getDefinition().endSQLStatement();
        this.getRows(selectStatement);
        return this;
    }

    public DBTableOLD<E> getRowsByExample(E queryTemplate) throws SQLException, AccidentalBlankQueryException {
        this.template = queryTemplate;
        String whereClause = this.getSQLWhereClauseForExample(queryTemplate);
        String selectStatement = this.getSQLSelectAndFromForQuery() + whereClause + this.getOrderByClause() + this.database.getDefinition().endSQLStatement();
        return this.getRows(selectStatement);
    }

    public E getOnlyRowByExample(E queryTemplate) throws SQLException, UnexpectedNumberOfRowsException, AccidentalBlankQueryException {
        return (E)((DBRow)this.getRowsByExample(queryTemplate, (long)1L).listOfRows.get(0));
    }

    public DBTableOLD<E> getRowsByExample(E queryTemplate, long expectedNumberOfRows) throws SQLException, UnexpectedNumberOfRowsException, AccidentalBlankQueryException {
        DBTableOLD<E> rowsByExample = this.getRowsByExample(queryTemplate);
        int actualNumberOfRows = rowsByExample.toList().size();
        if ((long)actualNumberOfRows == expectedNumberOfRows) {
            return rowsByExample;
        }
        throw new UnexpectedNumberOfRowsException(expectedNumberOfRows, actualNumberOfRows, "Unexpected Number Of Rows Detected: was expecting " + expectedNumberOfRows + ", found " + actualNumberOfRows);
    }

    public String getSQLWhereClauseForExample(E row) throws AccidentalBlankQueryException {
        if (!this.blankQueryAllowed && ((DBRow)row).willCreateBlankQuery(this.database)) {
            throw new AccidentalBlankQueryException();
        }
        StringBuilder whereClause = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        DBDefinition defn = this.database.getDefinition();
        List<String> tabRowCriteria = ((DBRow)row).getWhereClausesWithoutAliases(this.database);
        if (tabRowCriteria != null && !tabRowCriteria.isEmpty()) {
            for (String clause : tabRowCriteria) {
                whereClause.append(lineSep).append(defn.beginConditionClauseLine(this.options)).append(clause);
            }
        }
        return whereClause.toString();
    }

    @Deprecated
    public String getSQLForExample(E row) throws AccidentalBlankQueryException {
        return this.getSQLWhereClauseForExample(row);
    }

    public DBTableOLD<E> getRowsByRawSQL(String sqlWhereClause) throws SQLException {
        if (sqlWhereClause.toLowerCase().matches("^\\s*and\\s+.*")) {
            String whereClause = sqlWhereClause.replaceAll("\\s*;\\s*$", "");
            String selectStatement = this.getSQLSelectAndFromForQuery() + whereClause + this.getOrderByClause() + this.database.getDefinition().endSQLStatement();
            return this.getRows(selectStatement);
        }
        String whereClause = " AND " + sqlWhereClause.replaceAll("\\s*;\\s*$", "");
        String selectStatement = this.getSQLSelectAndFromForQuery() + whereClause + this.getOrderByClause() + this.database.getDefinition().endSQLStatement();
        return this.getRows(selectStatement);
    }

    public void print() throws SQLException, AccidentalBlankQueryException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        this.print(System.out);
    }

    public void print(PrintStream ps) throws SQLException, AccidentalBlankQueryException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        for (DBRow row : this.listOfRows) {
            ps.println(row);
        }
    }

    public E getFirstRow() throws SQLException, AccidentalBlankQueryException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        if (this.listOfRows.size() > 0) {
            return (E)((DBRow)this.listOfRows.get(0));
        }
        return null;
    }

    public E getOnlyRow() throws UnexpectedNumberOfRowsException, SQLException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        if (this.listOfRows.size() > 0) {
            return (E)((DBRow)this.listOfRows.get(0));
        }
        throw new UnexpectedNumberOfRowsException(1L, this.listOfRows.size(), "Unexpected Number Of Rows Detected: was expecting 1, found " + this.listOfRows.size());
    }

    public final DBActionList insert(E ... newRows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (E row : newRows) {
            actions.addAll(DBInsert.save(this.database, row));
        }
        return actions;
    }

    public DBActionList insert(List<E> newRows) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        for (DBRow row : newRows) {
            changes.addAll(DBInsert.save(this.database, row));
        }
        return changes;
    }

    public final DBActionList delete(E ... oldRows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (E row : oldRows) {
            actions.addAll(DBDelete.delete(this.database, row));
        }
        return actions;
    }

    public DBActionList delete(List<E> oldRows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (DBRow row : oldRows) {
            actions.addAll(DBDelete.delete(this.database, row));
        }
        return actions;
    }

    public DBActionList update(E oldRow) throws SQLException {
        return DBUpdate.update(this.database, oldRow);
    }

    public DBActionList update(List<E> oldRows) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        for (DBRow row : oldRows) {
            if (!row.hasChangedSimpleTypes()) continue;
            changes.addAll(DBUpdate.update(this.database, row));
        }
        return changes;
    }

    public String getSQLWhereClauseWithExampleAndRawSQL(E query, String sqlWhereClause) {
        if (sqlWhereClause.toLowerCase().matches("^\\s*and\\s+.*")) {
            return this.getSQLWhereClauseForExample(query) + sqlWhereClause.replaceAll("\\s*;\\s*$", "");
        }
        return this.getSQLWhereClauseForExample(query) + " AND " + sqlWhereClause.replaceAll("\\s*;\\s*$", "");
    }

    public List<E> toList() throws SQLException, AccidentalBlankQueryException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        return new ArrayList<E>(this.listOfRows);
    }

    public List<Long> getPrimaryKeysAsLong() throws SQLException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        ArrayList<Long> primaryKeys = new ArrayList<Long>();
        for (DBRow e : this.listOfRows) {
            Object primaryKeyQDT = e.getPrimaryKey();
            if (!(primaryKeyQDT instanceof DBNumber)) continue;
            DBNumber pkAsDBNumber = (DBNumber)primaryKeyQDT;
            primaryKeys.add(pkAsDBNumber.longValue());
        }
        return primaryKeys;
    }

    public List<String> getPrimaryKeysAsString() throws SQLException {
        if (this.resultSet == null) {
            this.getRowsByExample(this.template);
        }
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (DBRow e : this.listOfRows) {
            primaryKeys.add(((QueryableDatatype)e.getPrimaryKey()).toString());
        }
        return primaryKeys;
    }

    public void compare(DBTableOLD<E> secondTable) throws SQLException {
        HashMap<String, DBRow> secondMap = new HashMap<String, DBRow>();
        for (DBRow row : secondTable.toList()) {
            secondMap.put(((QueryableDatatype)row.getPrimaryKey()).toString(), row);
        }
        for (DBRow row : this.toList()) {
            DBRow foundRow = (DBRow)secondMap.get(((QueryableDatatype)row.getPrimaryKey()).toString());
            if (foundRow == null) {
                System.out.println("NOT FOUND: " + row);
                continue;
            }
            if (row.toString().equals(foundRow.toString())) continue;
            System.out.println("DIFFERENT: " + row);
            System.out.println("         : " + foundRow);
        }
    }

    public DBTableOLD<E> setRowLimit(int i) {
        this.resultSet = null;
        this.rowLimit = new Long(i);
        return this;
    }

    public DBTableOLD<E> clearRowLimit() {
        this.resultSet = null;
        this.rowLimit = null;
        return this;
    }

    public DBTableOLD<E> setSortOrder(E baseRow, QueryableDatatype ... orderColumns) {
        this.resultSet = null;
        this.sortOrder = new ArrayList<PropertyWrapper>();
        for (QueryableDatatype qdt : orderColumns) {
            PropertyWrapper prop = ((RowDefinition)baseRow).getPropertyWrapperOf(qdt);
            if (prop == null) {
                throw new IncorrectRowProviderInstanceSuppliedException((RowDefinition)baseRow, qdt);
            }
            this.sortOrder.add(prop);
        }
        return this;
    }

    public DBTableOLD<E> clearSortOrder() {
        this.resultSet = null;
        this.sortOrder = null;
        return this;
    }

    private String getOrderByClause() {
        DBDefinition defn = this.database.getDefinition();
        if (this.sortOrder != null) {
            StringBuilder orderByClause = new StringBuilder(defn.beginOrderByClause());
            String sortSeparator = defn.getStartingOrderByClauseSeparator();
            for (PropertyWrapper prop : this.sortOrder) {
                Object qdt = prop.getQueryableDatatype();
                String dbColumnName = prop.columnName();
                if (dbColumnName == null) continue;
                orderByClause.append(sortSeparator).append(defn.formatColumnName(dbColumnName)).append(defn.getOrderByDirectionClause(((QueryableDatatype)qdt).getSortOrder()));
                sortSeparator = defn.getSubsequentOrderByClauseSeparator();
            }
            orderByClause.append(defn.endOrderByClause());
            return orderByClause.toString();
        }
        return "";
    }

    public DBTableOLD<E> setBlankQueryAllowed(boolean allow) {
        this.blankQueryAllowed = allow;
        return this;
    }

    public void setToMatchAnyCondition() {
        this.options.setMatchAnyConditions();
    }

    public void setToMatchAllConditions() {
        this.options.setMatchAllConditions();
    }
}

