/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution;

import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBQuery;
import nz.co.gregs.dbvolution.DBQueryRow;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBDelete;
import nz.co.gregs.dbvolution.actions.DBInsert;
import nz.co.gregs.dbvolution.actions.DBUpdate;
import nz.co.gregs.dbvolution.columns.ColumnProvider;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.AccidentalBlankQueryException;
import nz.co.gregs.dbvolution.exceptions.UnexpectedNumberOfRowsException;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class DBTable<E extends DBRow> {
    private E exemplar = null;
    private E original = null;
    private final DBDatabase database;
    private DBQuery query = null;
    private final QueryOptions options = new QueryOptions();

    protected DBTable(DBDatabase database, E exampleRow) {
        this.original = exampleRow;
        this.exemplar = DBRow.copyDBRow(exampleRow);
        this.database = database;
        this.query = database.getDBQuery(new DBRow[]{this.exemplar});
    }

    public static <E extends DBRow> DBTable<E> getInstance(DBDatabase database, E example) {
        DBTable<E> dbTable = new DBTable<E>(database, example);
        return dbTable;
    }

    public List<E> getAllRows() throws SQLException {
        this.query.refreshQuery();
        this.applyConfigs();
        return this.query.getAllInstancesOf(this.exemplar);
    }

    public List<E> toList() throws SQLException {
        return this.getAllRows();
    }

    public List<E> getRowsByExample(E example) throws SQLException {
        this.exemplar = DBRow.copyDBRow(example);
        this.query = this.database.getDBQuery(new DBRow[]{this.exemplar});
        return this.getAllRows();
    }

    public E getFirstRow() throws SQLException {
        List<E> allRows = this.getAllRows();
        return (E)((DBRow)allRows.get(0));
    }

    public E getOnlyRow() throws SQLException, UnexpectedNumberOfRowsException {
        List<E> allRows = this.getAllRows();
        if (allRows.size() != 1) {
            throw new UnexpectedNumberOfRowsException(1L, allRows.size());
        }
        return (E)((DBRow)allRows.get(0));
    }

    public E getOnlyRowByExample(E example) throws SQLException, UnexpectedNumberOfRowsException, AccidentalBlankQueryException {
        return (E)((DBRow)this.getRowsByExample(example, 1L).get(0));
    }

    public List<E> getRowsByExample(E example, long expectedNumberOfRows) throws SQLException, UnexpectedNumberOfRowsException, AccidentalBlankQueryException {
        List<E> rowsByExample = this.getRowsByExample(example);
        if ((long)rowsByExample.size() == expectedNumberOfRows) {
            return rowsByExample;
        }
        throw new UnexpectedNumberOfRowsException(expectedNumberOfRows, rowsByExample.size());
    }

    private List<E> getRowsByPrimaryKeyObject(Object pkValue) throws SQLException, ClassNotFoundException {
        Object newInstance = DBRow.getDBRow(this.exemplar.getClass());
        Object primaryKey = ((DBRow)newInstance).getPrimaryKey();
        if (primaryKey instanceof DBString && pkValue instanceof String) {
            ((DBString)primaryKey).permittedValues((String)pkValue);
        } else if (primaryKey instanceof DBInteger && pkValue instanceof Long) {
            ((DBInteger)primaryKey).permittedValues((Long)pkValue);
        } else if (primaryKey instanceof DBInteger && pkValue instanceof Integer) {
            ((DBInteger)primaryKey).permittedValues((Integer)pkValue);
        } else if (primaryKey instanceof DBNumber && pkValue instanceof Number) {
            ((DBNumber)primaryKey).permittedValues((Number)pkValue);
        } else if (primaryKey instanceof DBDate && pkValue instanceof Date) {
            ((DBDate)primaryKey).permittedValues((Date)pkValue);
        } else if (primaryKey instanceof DBBoolean && pkValue instanceof Boolean) {
            ((DBBoolean)primaryKey).permittedValues((Boolean)pkValue);
        } else {
            throw new ClassNotFoundException("The value supplied is not in a supported class or it does not match the primary key class.");
        }
        this.query = this.database.getDBQuery(new DBRow[]{newInstance});
        return this.getAllRows();
    }

    public List<E> getRowsByPrimaryKey(Number pkValue) throws SQLException, ClassNotFoundException {
        return this.getRowsByPrimaryKeyObject(pkValue);
    }

    public List<E> getRowsByPrimaryKey(String pkValue) throws SQLException, ClassNotFoundException {
        return this.getRowsByPrimaryKeyObject(pkValue);
    }

    public List<E> getRowsByPrimaryKey(Date pkValue) throws SQLException, ClassNotFoundException {
        return this.getRowsByPrimaryKeyObject(pkValue);
    }

    public String getSQLForQuery() throws SQLException {
        return this.query.getSQLForQuery();
    }

    public String getSQLForCount() throws SQLException {
        return this.query.getSQLForCount();
    }

    public Long count() throws SQLException {
        return this.query.count();
    }

    public void print() throws SQLException {
        this.print(System.out);
    }

    public void print(PrintStream stream) throws SQLException {
        List<E> allRows = this.getAllRows();
        for (DBRow row : allRows) {
            stream.println(row);
        }
    }

    public final DBActionList insert(E ... newRows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (E row : newRows) {
            actions.addAll(DBInsert.save(this.database, row));
        }
        this.query.refreshQuery();
        return actions;
    }

    public DBActionList insert(Collection<E> newRows) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        for (DBRow row : newRows) {
            changes.addAll(DBInsert.save(this.database, row));
        }
        this.query.refreshQuery();
        return changes;
    }

    public final DBActionList delete(E ... oldRows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (E row : oldRows) {
            actions.addAll(DBDelete.delete(this.database, row));
        }
        this.query.refreshQuery();
        return actions;
    }

    public DBActionList delete(Collection<E> oldRows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (DBRow row : oldRows) {
            actions.addAll(DBDelete.delete(this.database, row));
        }
        this.query.refreshQuery();
        return actions;
    }

    public DBActionList update(E oldRow) throws SQLException {
        this.query.refreshQuery();
        DBActionList updates = DBUpdate.update(this.database, oldRow);
        ((DBRow)oldRow).setSimpleTypesToUnchanged();
        return updates;
    }

    public DBActionList update(Collection<E> oldRows) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        for (DBRow row : oldRows) {
            if (!row.hasChangedSimpleTypes()) continue;
            changes.addAll(DBUpdate.update(this.database, row));
            row.setSimpleTypesToUnchanged();
        }
        this.query.refreshQuery();
        return changes;
    }

    public List<Long> getPrimaryKeysAsLong() throws SQLException {
        List<E> allRows = this.getAllRows();
        ArrayList<Long> longPKs = new ArrayList<Long>();
        for (DBRow row : allRows) {
            Object primaryKey = row.getPrimaryKey();
            if (!DBNumber.class.isAssignableFrom(primaryKey.getClass())) continue;
            DBNumber num = (DBNumber)primaryKey;
            longPKs.add(num.longValue());
        }
        return longPKs;
    }

    public List<String> getPrimaryKeysAsString() throws SQLException {
        List<E> allRows = this.getAllRows();
        ArrayList<String> stringPKs = new ArrayList<String>();
        for (DBRow row : allRows) {
            stringPKs.add(((QueryableDatatype)row.getPrimaryKey()).stringValue());
        }
        return stringPKs;
    }

    public void compare(DBTable<E> secondTable) throws SQLException {
        HashMap<String, DBRow> secondMap = new HashMap<String, DBRow>();
        for (DBRow row : secondTable.getAllRows()) {
            secondMap.put(((QueryableDatatype)row.getPrimaryKey()).toString(), row);
        }
        for (DBRow row : this.getAllRows()) {
            DBRow foundRow = (DBRow)secondMap.get(((QueryableDatatype)row.getPrimaryKey()).toString());
            if (foundRow == null) {
                System.out.println("NOT FOUND: " + row);
                continue;
            }
            if (row.toString().equals(foundRow.toString())) continue;
            System.out.println("DIFFERENT: " + row);
            System.out.println("         : " + foundRow);
        }
    }

    public DBTable<E> setRowLimit(int rowLimit) {
        this.options.setRowLimit(rowLimit);
        return this;
    }

    private DBTable<E> applyRowLimit() {
        if (this.options.getRowLimit() > 0) {
            this.query.setRowLimit(this.options.getRowLimit());
        } else {
            this.query.clearRowLimit();
        }
        return this;
    }

    public DBTable<E> clearRowLimit() {
        this.options.setRowLimit(-1);
        return this;
    }

    public DBTable<E> setSortOrder(ColumnProvider ... sortColumns) {
        this.options.setSortColumns(sortColumns);
        return this;
    }

    public DBTable<E> clearSortOrder() {
        if (this.options.getSortColumns().length > 0) {
            this.options.setSortColumns(new ColumnProvider[0]);
        }
        return this;
    }

    private void applySortOrder() {
        if (this.options.getSortColumns().length > 0) {
            this.query.setSortOrder(this.options.getSortColumns());
        } else {
            this.query.clearSortOrder();
        }
    }

    public DBTable<E> setBlankQueryAllowed(boolean allow) {
        this.options.setBlankQueryAllowed(allow);
        return this;
    }

    private void applyBlankQueryAllowed() {
        this.query.setBlankQueryAllowed(this.options.isBlankQueryAllowed());
    }

    private void applyConfigs() {
        this.applyBlankQueryAllowed();
        this.applyRowLimit();
        this.applySortOrder();
        this.applyMatchAny();
    }

    public void setToMatchAnyCondition() {
        this.options.setMatchAnyConditions();
    }

    public void setToMatchAllConditions() {
        this.options.setMatchAllConditions();
    }

    private void applyMatchAny() {
        if (this.options.isMatchAny()) {
            this.query.setToMatchAnyCondition();
        } else if (this.options.isMatchAllConditions()) {
            this.query.setToMatchAllConditions();
        }
    }

    public DBTable<E> setRawSQL(String rawQuery) throws SQLException {
        this.query.setRawSQL(rawQuery);
        return this;
    }

    public <A> List<A> getDistinctValuesOfColumn(A fieldOfProvidedRow) throws AccidentalBlankQueryException, SQLException {
        ArrayList<Object> returnList = new ArrayList<Object>();
        PropertyWrapper fieldProp = ((RowDefinition)this.original).getPropertyWrapperOf(fieldOfProvidedRow);
        PropertyWrapperDefinition fieldDefn = fieldProp.getDefinition();
        QueryableDatatype thisQDT = fieldDefn.getQueryableDatatype(this.exemplar);
        ((DBRow)this.exemplar).setReturnFields((QueryableDatatype[])new QueryableDatatype[]{thisQDT});
        DBQuery distinctQuery = this.database.getDBQuery(new DBRow[]{this.exemplar});
        distinctQuery.setBlankQueryAllowed(true);
        DBExpression column = ((RowDefinition)this.exemplar).column(thisQDT);
        if (column instanceof ColumnProvider) {
            distinctQuery.setSortOrder((ColumnProvider)((Object)column));
        }
        distinctQuery.addGroupByColumn(this.exemplar, column);
        List<DBQueryRow> allRows = distinctQuery.getAllRows();
        for (DBQueryRow dBQueryRow : allRows) {
            E found = dBQueryRow.get(this.exemplar);
            returnList.add(found == null ? (Object)null : fieldDefn.rawJavaValue(found));
        }
        return returnList;
    }
}

