/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBQuery;
import nz.co.gregs.dbvolution.DBQueryRow;
import nz.co.gregs.dbvolution.columns.ColumnProvider;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.ForeignKeyCannotBeComparedToPrimaryKey;
import nz.co.gregs.dbvolution.exceptions.IncorrectRowProviderInstanceSuppliedException;
import nz.co.gregs.dbvolution.exceptions.UnableToInstantiateDBRowSubclassException;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionClassWrapper;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionInstanceWrapper;
import nz.co.gregs.dbvolution.operators.DBOperator;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.query.RowDefinition;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public abstract class DBRow
extends RowDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isDefined = false;
    private final List<PropertyWrapperDefinition> ignoredForeignKeys = Collections.synchronizedList(new ArrayList());
    private List<PropertyWrapperDefinition> returnColumns = null;
    private final List<BooleanExpression> adHocRelationships = Collections.synchronizedList(new ArrayList());
    private transient Boolean hasBlobs;
    private final transient List<PropertyWrapper> fkFields = new ArrayList<PropertyWrapper>();
    private final transient List<PropertyWrapper> blobColumns = new ArrayList<PropertyWrapper>();
    private final transient SortedSet<Class<? extends DBRow>> referencedTables = new TreeSet<Class<? extends DBRow>>(new ClassNameComparator());
    private String tableAlias;
    private Boolean emptyRow = true;

    public static <T extends DBRow> T getDBRow(Class<T> requiredDBRowClass) throws UnableToInstantiateDBRowSubclassException {
        try {
            return (T)((DBRow)requiredDBRowClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new UnableToInstantiateDBRowSubclassException(requiredDBRowClass, (Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new UnableToInstantiateDBRowSubclassException(requiredDBRowClass, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new UnableToInstantiateDBRowSubclassException(requiredDBRowClass, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnableToInstantiateDBRowSubclassException(requiredDBRowClass, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new UnableToInstantiateDBRowSubclassException(requiredDBRowClass, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new UnableToInstantiateDBRowSubclassException(requiredDBRowClass, (Throwable)ex);
        }
    }

    public static <R extends DBRow> R getPrimaryKeyExample(R sourceRow) {
        Object dbRow = DBRow.getDBRow(sourceRow.getClass());
        ((QueryableDatatype)((DBRow)dbRow).getPrimaryKey()).setValue(sourceRow.getPrimaryKey());
        return (R)dbRow;
    }

    public static <T extends DBRow> T copyDBRow(T originalRow) {
        Object newRow = DBRow.getDBRow(originalRow.getClass());
        ((DBRow)newRow).setDefined(originalRow.getDefined());
        for (PropertyWrapperDefinition defn : originalRow.getIgnoredForeignKeys()) {
            ((DBRow)newRow).getIgnoredForeignKeys().add(defn);
        }
        if (originalRow.getReturnColumns() != null) {
            ((DBRow)newRow).setReturnColumns(new ArrayList<PropertyWrapperDefinition>());
            for (PropertyWrapperDefinition defn : originalRow.getReturnColumns()) {
                ((DBRow)newRow).getReturnColumns().add(defn);
            }
        } else {
            ((DBRow)newRow).setReturnColumns(null);
        }
        for (BooleanExpression adhoc : originalRow.getAdHocRelationships()) {
            ((DBRow)newRow).getAdHocRelationships().add(adhoc);
        }
        List<PropertyWrapper> subclassFields = originalRow.getPropertyWrappers();
        for (PropertyWrapper field : subclassFields) {
            try {
                Object originalValue = field.rawJavaValue();
                if (originalValue instanceof QueryableDatatype) {
                    QueryableDatatype originalQDT = (QueryableDatatype)originalValue;
                    field.getDefinition().setRawJavaValue(newRow, originalQDT.copy());
                    continue;
                }
                field.getDefinition().setRawJavaValue(newRow, originalValue);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
        return (T)newRow;
    }

    @Deprecated
    public void clear() {
        for (PropertyWrapper prop : this.getPropertyWrappers()) {
            Object qdt = prop.getQueryableDatatype();
            if (qdt == null) continue;
            ((QueryableDatatype)qdt).clear();
            prop.setQueryableDatatype((QueryableDatatype)qdt);
        }
    }

    public <A extends QueryableDatatype> A getPrimaryKey() {
        PropertyWrapper primaryKeyPropertyWrapper = this.getPrimaryKeyPropertyWrapper();
        if (primaryKeyPropertyWrapper == null) {
            return null;
        }
        Object queryableValueOfField = primaryKeyPropertyWrapper.getQueryableDatatype();
        return queryableValueOfField;
    }

    public Integer getPrimaryKeyIndex() {
        PropertyWrapper primaryKeyPropertyWrapper = this.getPrimaryKeyPropertyWrapper();
        if (primaryKeyPropertyWrapper == null) {
            return null;
        }
        return primaryKeyPropertyWrapper.getDefinition().getColumnIndex();
    }

    @Deprecated
    protected void setDefined(boolean newValue) {
        this.isDefined = newValue;
    }

    public boolean getDefined() {
        return this.isDefined;
    }

    public void setUndefined() {
        this.isDefined = false;
    }

    public void setDefined() {
        this.isDefined = true;
    }

    public boolean hasChangedSimpleTypes() {
        List<PropertyWrapper> propertyWrappers = this.getWrapper().getPropertyWrappers();
        for (PropertyWrapper prop : propertyWrappers) {
            if (prop.getQueryableDatatype() instanceof DBLargeObject || !((QueryableDatatype)prop.getQueryableDatatype()).hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void setSimpleTypesToUnchanged() {
        List<PropertyWrapper> propertyWrappers = this.getWrapper().getPropertyWrappers();
        for (PropertyWrapper prop : propertyWrappers) {
            Object qdt = prop.getQueryableDatatype();
            if (qdt instanceof DBLargeObject || !((QueryableDatatype)qdt).hasChanged()) continue;
            ((QueryableDatatype)qdt).setUnchanged();
            prop.setQueryableDatatype((QueryableDatatype)qdt);
        }
    }

    public String getPrimaryKeyColumnName() {
        PropertyWrapper primaryKeyPropertyWrapper = this.getPrimaryKeyPropertyWrapper();
        if (primaryKeyPropertyWrapper == null) {
            return null;
        }
        return primaryKeyPropertyWrapper.columnName();
    }

    public String getPrimaryKeyFieldName() {
        PropertyWrapper primaryKeyPropertyWrapper = this.getPrimaryKeyPropertyWrapper();
        if (primaryKeyPropertyWrapper == null) {
            return null;
        }
        return primaryKeyPropertyWrapper.javaName();
    }

    protected PropertyWrapper getPrimaryKeyPropertyWrapper() {
        return this.getWrapper().primaryKey();
    }

    public List<String> getWhereClausesWithoutAliases(DBDatabase db) {
        return this.getWhereClauses(db, false);
    }

    public List<String> getWhereClausesWithAliases(DBDatabase db) {
        return this.getWhereClauses(db, true);
    }

    private List<String> getWhereClauses(DBDatabase db, boolean useTableAlias) {
        DBDefinition defn = db.getDefinition();
        ArrayList<String> whereClause = new ArrayList<String>();
        List<PropertyWrapper> props = this.getWrapper().getPropertyWrappers();
        for (PropertyWrapper prop : props) {
            if (!prop.isColumn()) continue;
            Object qdt = prop.getQueryableDatatype();
            String possibleWhereClause = useTableAlias ? ((QueryableDatatype)qdt).getWhereClause(db, prop.getSelectableName(db)) : ((QueryableDatatype)qdt).getWhereClause(db, defn.formatTableAndColumnName(this, prop.columnName()));
            if (possibleWhereClause.replaceAll(" ", "").isEmpty()) continue;
            whereClause.add("(" + possibleWhereClause + ")");
        }
        return whereClause;
    }

    public boolean willCreateBlankQuery(DBDatabase db) {
        List<String> whereClause = this.getWhereClausesWithoutAliases(db);
        return whereClause == null || whereClause.isEmpty();
    }

    public String getTableName() {
        return this.getWrapper().tableName();
    }

    public String toStringMinusFKs() {
        StringBuilder string = new StringBuilder();
        List<PropertyWrapper> fields = this.getWrapper().getPropertyWrappers();
        String separator = "";
        for (PropertyWrapper field : fields) {
            if (!field.isColumn() || field.isForeignKey()) continue;
            string.append(separator);
            string.append(" ");
            string.append(field.javaName());
            string.append(":");
            string.append(field.getQueryableDatatype());
            separator = ",";
        }
        return string.toString();
    }

    @Deprecated
    protected List<String> getColumnNames(DBDatabase db) {
        DBDefinition defn = db.getDefinition();
        ArrayList<String> columnNames = new ArrayList<String>();
        List<PropertyWrapper> props = this.getWrapper().getPropertyWrappers();
        for (PropertyWrapper prop : props) {
            String dbColumnName;
            if (!prop.isColumn()) continue;
            if (prop.hasColumnExpression()) {
                columnNames.add(prop.getColumnExpression().toSQLString(db));
                continue;
            }
            if (this.getReturnColumns() != null && !this.getReturnColumns().contains(prop.getDefinition()) || (dbColumnName = prop.columnName()) == null) continue;
            columnNames.add(defn.formatTableAliasAndColumnNameForSelectClause(this, dbColumnName));
        }
        return columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyWrapper> getForeignKeyPropertyWrappers() {
        List<PropertyWrapper> list = this.fkFields;
        synchronized (list) {
            if (this.fkFields.isEmpty()) {
                List<PropertyWrapper> props = this.getWrapper().getForeignKeyPropertyWrappers();
                for (PropertyWrapper prop : props) {
                    if (!prop.isColumn() || !prop.isForeignKey() || this.ignoredForeignKeys.contains(prop.getDefinition())) continue;
                    this.fkFields.add(prop);
                }
            }
            return this.fkFields;
        }
    }

    public void ignoreForeignKey(Object qdt) throws IncorrectRowProviderInstanceSuppliedException {
        PropertyWrapper fkProp = this.getPropertyWrapperOf(qdt);
        if (fkProp == null) {
            throw new IncorrectRowProviderInstanceSuppliedException(this, qdt);
        }
        this.getIgnoredForeignKeys().add(fkProp.getDefinition());
        this.fkFields.clear();
    }

    public void ignoreForeignKeys(Object ... qdts) throws IncorrectRowProviderInstanceSuppliedException {
        for (Object object : qdts) {
            this.ignoreForeignKey(object);
        }
    }

    public void ignoreForeignKeys(ColumnProvider ... columns) throws IncorrectRowProviderInstanceSuppliedException {
        for (ColumnProvider col : columns) {
            this.ignoreForeignKey(col);
        }
    }

    public void ignoreForeignKey(ColumnProvider column) {
        PropertyWrapper fkProp = column.getColumn().getPropertyWrapper();
        this.getIgnoredForeignKeys().add(fkProp.getDefinition());
        this.fkFields.clear();
    }

    public void useAllForeignKeys() {
        this.getIgnoredForeignKeys().clear();
        this.fkFields.clear();
    }

    public void ignoreAllForeignKeys() {
        List<PropertyWrapper> props = this.getForeignKeyPropertyWrappers();
        for (PropertyWrapper prop : props) {
            this.getIgnoredForeignKeys().add(prop.getDefinition());
        }
        this.fkFields.clear();
    }

    public void ignoreAllForeignKeysExcept(Object ... importantForeignKeys) {
        ArrayList<PropertyWrapperDefinition> importantFKs = new ArrayList<PropertyWrapperDefinition>();
        for (Object object : importantForeignKeys) {
            PropertyWrapper importantProp = this.getPropertyWrapperOf(object);
            if (importantProp == null || !importantProp.isColumn() || !importantProp.isForeignKey()) continue;
            importantFKs.add(importantProp.getDefinition());
        }
        List<PropertyWrapper> props = this.getForeignKeyPropertyWrappers();
        for (PropertyWrapper prop : props) {
            PropertyWrapperDefinition propDefn = prop.getDefinition();
            if (importantFKs.contains(propDefn)) continue;
            this.getIgnoredForeignKeys().add(propDefn);
        }
        this.fkFields.clear();
    }

    public void addRelationship(DBBoolean thisTableField, DBRow otherTable, DBBoolean otherTableField) {
        this.getAdHocRelationships().add(this.column(thisTableField).is(otherTable.column(otherTableField)));
    }

    public void addRelationship(DBDate thisTableField, DBRow otherTable, DBDate otherTableField) {
        this.getAdHocRelationships().add(this.column(thisTableField).is(otherTable.column(otherTableField)));
    }

    public void addRelationship(DBInteger thisTableField, DBRow otherTable, DBInteger otherTableField) {
        this.getAdHocRelationships().add(this.column(thisTableField).is(otherTable.column(otherTableField)));
    }

    public void addRelationship(DBNumber thisTableField, DBRow otherTable, DBNumber otherTableField) {
        this.getAdHocRelationships().add(this.column(thisTableField).is(otherTable.column(otherTableField)));
    }

    public void addRelationship(DBString thisTableField, DBRow otherTable, DBString otherTableField) {
        this.getAdHocRelationships().add(this.column(thisTableField).is(otherTable.column(otherTableField)));
    }

    @Deprecated
    public void addRelationship(QueryableDatatype thisTableField, DBRow otherTable, QueryableDatatype otherTableField, DBOperator operator) {
    }

    public void clearRelationships() {
        this.getAdHocRelationships().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLargeObjects() {
        List<PropertyWrapper> list = this.blobColumns;
        synchronized (list) {
            if (this.hasBlobs == null) {
                this.hasBlobs = Boolean.FALSE;
                for (PropertyWrapper prop : this.getPropertyWrappers()) {
                    if (!prop.isInstanceOf(DBLargeObject.class)) continue;
                    this.blobColumns.add(prop);
                    this.hasBlobs = Boolean.TRUE;
                }
            }
            return this.hasBlobs;
        }
    }

    public final <T> void setReturnFields(T ... fields) throws IncorrectRowProviderInstanceSuppliedException {
        this.setReturnColumns(new ArrayList<PropertyWrapperDefinition>());
        for (T property : fields) {
            PropertyWrapper propWrapper = this.getPropertyWrapperOf(property);
            if (propWrapper == null) {
                throw new IncorrectRowProviderInstanceSuppliedException(this, property);
            }
            this.getReturnColumns().add(propWrapper.getDefinition());
        }
    }

    public final <T> void addReturnFields(T ... fields) throws IncorrectRowProviderInstanceSuppliedException {
        if (this.getReturnColumns() == null) {
            this.setReturnColumns(new ArrayList<PropertyWrapperDefinition>());
        }
        for (T property : fields) {
            PropertyWrapper propWrapper = this.getPropertyWrapperOf(property);
            if (propWrapper == null) {
                throw new IncorrectRowProviderInstanceSuppliedException(this, property);
            }
            this.getReturnColumns().add(propWrapper.getDefinition());
        }
    }

    protected final void removeAllFieldsFromResults() {
        this.setReturnFields(new Object[0]);
    }

    public void returnAllFields() {
        this.setReturnColumns(null);
    }

    protected List<BooleanExpression> getAdHocRelationships() {
        return this.adHocRelationships;
    }

    public String getRelationshipsAsSQL(DBDatabase db, DBRow newTable, QueryOptions options) {
        StringBuilder rels = new StringBuilder();
        DBDefinition defn = db.getDefinition();
        List<PropertyWrapper> fks = this.getForeignKeyPropertyWrappers();
        String joinSeparator = "";
        for (PropertyWrapper fk : fks) {
            Class<? extends DBRow> referencedClass = fk.referencedClass();
            if (!referencedClass.isAssignableFrom(newTable.getClass()) && !newTable.getClass().isAssignableFrom(referencedClass)) continue;
            String formattedForeignKey = defn.formatTableAliasAndColumnName(this, fk.columnName());
            String formattedReferencedColumn = defn.formatTableAliasAndColumnName(newTable, fk.referencedColumnName());
            rels.append(joinSeparator).append(formattedForeignKey).append(defn.getEqualsComparator()).append(formattedReferencedColumn);
            joinSeparator = defn.beginConditionClauseLine(options);
        }
        List<BooleanExpression> adHocs = this.getAdHocRelationships();
        for (BooleanExpression adhoc : adHocs) {
            rels.append(joinSeparator).append(adhoc.toSQLString(db));
            joinSeparator = defn.beginConditionClauseLine(options);
        }
        adHocs = newTable.getAdHocRelationships();
        for (BooleanExpression adhoc : adHocs) {
            rels.append(joinSeparator).append(adhoc.toSQLString(db));
            joinSeparator = defn.beginConditionClauseLine(options);
        }
        fks = newTable.getForeignKeyPropertyWrappers();
        for (PropertyWrapper fk : fks) {
            Class<? extends DBRow> value = fk.referencedClass();
            if (!this.getClass().isAssignableFrom(value)) continue;
            String fkColumnName = fk.columnName();
            String formattedForeignKey = defn.formatTableAliasAndColumnName(newTable, fkColumnName);
            String formattedPrimaryKey = defn.formatTableAliasAndColumnName(this, this.getPrimaryKeyColumnName());
            rels.append(joinSeparator).append(formattedPrimaryKey).append(defn.getEqualsComparator()).append(formattedForeignKey);
            joinSeparator = defn.beginConditionClauseLine(options);
        }
        return rels.toString();
    }

    public List<BooleanExpression> getRelationshipsAsBooleanExpressions(DBDatabase db, DBRow otherTable, QueryOptions options) {
        Class<? extends DBRow> referencedClass;
        ArrayList<BooleanExpression> rels = new ArrayList<BooleanExpression>();
        List<PropertyWrapper> fks = this.getForeignKeyPropertyWrappers();
        for (PropertyWrapper fk : fks) {
            referencedClass = fk.referencedClass();
            if (!referencedClass.isAssignableFrom(otherTable.getClass())) continue;
            rels.add(DBRow.getRelationshipExpressionFor(this, fk, otherTable));
        }
        fks = otherTable.getForeignKeyPropertyWrappers();
        for (PropertyWrapper fk : fks) {
            referencedClass = fk.referencedClass();
            if (!referencedClass.isAssignableFrom(this.getClass())) continue;
            rels.add(DBRow.getRelationshipExpressionFor(otherTable, fk, this));
        }
        List<BooleanExpression> adHocs = this.getAdHocRelationships();
        rels.addAll(adHocs);
        for (BooleanExpression adhoc : adHocs) {
            rels.add(adhoc);
        }
        return rels;
    }

    public boolean willBeConnectedTo(DBDatabase database, DBRow otherTable, QueryOptions options) {
        List<BooleanExpression> relationshipsAsBooleanExpressions = this.getRelationshipsAsBooleanExpressions(database, otherTable, options);
        relationshipsAsBooleanExpressions.addAll(otherTable.getRelationshipsAsBooleanExpressions(database, this, options));
        return !relationshipsAsBooleanExpressions.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<Class<? extends DBRow>> getReferencedTables() {
        SortedSet<Class<? extends DBRow>> sortedSet = this.referencedTables;
        synchronized (sortedSet) {
            if (this.referencedTables.isEmpty()) {
                List<PropertyWrapper> props = this.getWrapper().getForeignKeyPropertyWrappers();
                for (PropertyWrapper prop : props) {
                    this.referencedTables.add(prop.referencedClass());
                }
            }
        }
        TreeSet<Class<? extends DBRow>> returnSet = new TreeSet<Class<? extends DBRow>>(new ClassNameComparator());
        returnSet.addAll(this.referencedTables);
        return returnSet;
    }

    public SortedSet<Class<? extends DBRow>> getAllConnectedTables() {
        TreeSet<Class<? extends DBRow>> relatedTables = new TreeSet<Class<? extends DBRow>>(new ClassNameComparator());
        relatedTables.addAll(this.getRelatedTables());
        relatedTables.addAll(this.getReferencedTables());
        return relatedTables;
    }

    public SortedSet<Class<? extends DBRow>> getRelatedTables() {
        TreeSet<Class<? extends DBRow>> relatedTables = new TreeSet<Class<? extends DBRow>>(new ClassNameComparator());
        Reflections reflections = new Reflections(this.getClass().getPackage().getName(), new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(DBRow.class);
        for (Class tableClass : subTypes) {
            try {
                DBRow newInstance = (DBRow)tableClass.newInstance();
                if (!newInstance.getReferencedTables().contains(this.getClass())) continue;
                relatedTables.add(tableClass);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        return relatedTables;
    }

    public void ignoreAllForeignKeysExceptFKsTo(DBRow ... goodTables) {
        List<PropertyWrapper> props = this.getWrapper().getForeignKeyPropertyWrappers();
        for (PropertyWrapper prop : props) {
            boolean ignore = true;
            for (DBRow goodTable : goodTables) {
                if (!prop.isForeignKeyTo(goodTable)) continue;
                ignore = false;
                break;
            }
            if (!ignore) continue;
            this.ignoreForeignKey(prop.getQueryableDatatype());
        }
    }

    public List<QueryableDatatype> getLargeObjects() {
        ArrayList<QueryableDatatype> returnList = new ArrayList<QueryableDatatype>();
        if (this.hasLargeObjects()) {
            for (PropertyWrapper propertyWrapper : this.blobColumns) {
                returnList.add((QueryableDatatype)propertyWrapper.getQueryableDatatype());
            }
        }
        return returnList;
    }

    public <R extends DBRow> List<R> getRelatedInstancesFromQuery(DBQuery query, R example) throws SQLException {
        ArrayList<R> instances = new ArrayList<R>();
        for (DBQueryRow qrow : query.getAllRows()) {
            DBRow versionOfThis = qrow.get(this);
            R versionOfThat = qrow.get(example);
            if (!versionOfThis.equals(this) || versionOfThat == null) continue;
            instances.add(versionOfThat);
        }
        return instances;
    }

    protected Boolean isEmptyRow() {
        return this.emptyRow;
    }

    protected void setEmptyRow(Boolean isThisRowEmpty) {
        this.emptyRow = isThisRowEmpty;
    }

    List<PropertyWrapper> getSelectedProperties() {
        if (this.getReturnColumns() == null) {
            return this.getPropertyWrappers();
        }
        ArrayList<PropertyWrapper> selected = new ArrayList<PropertyWrapper>();
        for (PropertyWrapperDefinition proDef : this.getReturnColumns()) {
            for (PropertyWrapper pro : this.getPropertyWrappers()) {
                if (!pro.getDefinition().equals(proDef)) continue;
                selected.add(pro);
            }
        }
        return selected;
    }

    boolean isPeerOf(DBRow table) {
        RowDefinitionClassWrapper thisClassWrapper = this.getWrapper().getClassWrapper();
        RowDefinitionClassWrapper thatClassWrapper = table.getWrapper().getClassWrapper();
        return thisClassWrapper.equals(thatClassWrapper);
    }

    public <R extends DBRow> List<QueryableDatatype> getForeignKeysTo(R row) {
        ArrayList<QueryableDatatype> fksToR = new ArrayList<QueryableDatatype>();
        RowDefinitionInstanceWrapper wrapper = this.getWrapper();
        List<PropertyWrapper> foreignKeyPropertyWrappers = wrapper.getForeignKeyPropertyWrappers();
        for (PropertyWrapper propertyWrapper : foreignKeyPropertyWrappers) {
            if (!propertyWrapper.isForeignKeyTo(row)) continue;
            fksToR.add((QueryableDatatype)propertyWrapper.getQueryableDatatype());
        }
        return fksToR;
    }

    public <R extends DBRow> List<DBExpression> getForeignKeyExpressionsTo(R target) {
        ArrayList<DBExpression> fksToR = new ArrayList<DBExpression>();
        RowDefinitionInstanceWrapper wrapper = this.getWrapper();
        List<PropertyWrapper> foreignKeyPropertyWrappers = wrapper.getForeignKeyPropertyWrappers();
        for (PropertyWrapper propertyWrapper : foreignKeyPropertyWrappers) {
            if (!propertyWrapper.isForeignKeyTo(target)) continue;
            RowDefinition source = propertyWrapper.getRowDefinitionInstanceWrapper().adapteeRowDefinition();
            Object sourceFK = propertyWrapper.getQueryableDatatype();
            QueryableDatatype targetPK = ((QueryableDatatype)target.getPrimaryKey()).getQueryableDatatypeForExpressionValue();
            DBExpression column = source.column((QueryableDatatype)sourceFK);
            try {
                Object fkExpression;
                Method isMethod = column.getClass().getMethod("is", targetPK.getClass());
                if (isMethod == null || !DBExpression.class.isAssignableFrom((fkExpression = isMethod.invoke((Object)column, targetPK)).getClass())) continue;
                fksToR.add((DBExpression)fkExpression);
            }
            catch (IllegalAccessException ex) {
                throw new ForeignKeyCannotBeComparedToPrimaryKey(ex, source, propertyWrapper, target, target.getPropertyWrapperOf(target.getPrimaryKey()));
            }
            catch (IllegalArgumentException ex) {
                throw new ForeignKeyCannotBeComparedToPrimaryKey(ex, source, propertyWrapper, target, target.getPropertyWrapperOf(target.getPrimaryKey()));
            }
            catch (NoSuchMethodException ex) {
                throw new ForeignKeyCannotBeComparedToPrimaryKey(ex, source, propertyWrapper, target, target.getPropertyWrapperOf(target.getPrimaryKey()));
            }
            catch (SecurityException ex) {
                throw new ForeignKeyCannotBeComparedToPrimaryKey(ex, source, propertyWrapper, target, target.getPropertyWrapperOf(target.getPrimaryKey()));
            }
            catch (InvocationTargetException ex) {
                throw new ForeignKeyCannotBeComparedToPrimaryKey(ex, source, propertyWrapper, target, target.getPropertyWrapperOf(target.getPrimaryKey()));
            }
        }
        return fksToR;
    }

    protected List<PropertyWrapperDefinition> getIgnoredForeignKeys() {
        return this.ignoredForeignKeys;
    }

    public void ignoreForeignKeyProperties(Collection<Object> ignoreTheseFKs) {
        for (Object qdt : ignoreTheseFKs) {
            this.ignoreForeignKey(qdt);
        }
    }

    public void ignoreForeignKeyColumns(Collection<ColumnProvider> ignoreTheseFKColumns) {
        for (ColumnProvider qdt : ignoreTheseFKColumns) {
            this.ignoreForeignKey(qdt);
        }
    }

    private static BooleanExpression getRelationshipExpressionFor(DBRow fkTable, PropertyWrapper fk, DBRow otherTable) {
        BooleanExpression expr = BooleanExpression.falseExpression();
        Object fkQDT = fk.getQueryableDatatype();
        Object pkQDT = otherTable.getPrimaryKey();
        if (fkQDT.getClass().isAssignableFrom(pkQDT.getClass()) || pkQDT.getClass().isAssignableFrom(fkQDT.getClass())) {
            if (DBBoolean.class.isAssignableFrom(fkQDT.getClass())) {
                expr = fkTable.column((DBBoolean)fkQDT).is(otherTable.column((DBBoolean)pkQDT));
            } else if (DBDate.class.isAssignableFrom(fkQDT.getClass())) {
                expr = fkTable.column((DBDate)fkQDT).is(otherTable.column((DBDate)pkQDT));
            } else if (DBInteger.class.isAssignableFrom(fkQDT.getClass())) {
                expr = fkTable.column((DBInteger)fkQDT).is(otherTable.column((DBInteger)pkQDT));
            } else if (DBNumber.class.isAssignableFrom(fkQDT.getClass())) {
                expr = fkTable.column((DBNumber)fkQDT).is(otherTable.column((DBNumber)pkQDT));
            } else if (DBString.class.isAssignableFrom(fkQDT.getClass())) {
                expr = fkTable.column((DBString)fkQDT).is(otherTable.column((DBString)pkQDT));
            }
        }
        return expr;
    }

    public <A> List<A> getDistinctValuesOfColumn(DBDatabase database, A fieldOfThisInstance) throws SQLException {
        ArrayList<Object> results = new ArrayList<Object>();
        PropertyWrapper fieldProp = this.getPropertyWrapperOf(fieldOfThisInstance);
        QueryableDatatype thisQDT = fieldProp.getDefinition().getQueryableDatatype(this);
        this.setReturnFields(fieldOfThisInstance);
        DBExpression column = this.column(thisQDT);
        DBQuery dbQuery = database.getDBQuery(this).addGroupByColumn(this, column);
        if (column instanceof ColumnProvider) {
            dbQuery.setSortOrder((ColumnProvider)((Object)column));
        }
        dbQuery.setBlankQueryAllowed(true);
        List<DBQueryRow> allRows = dbQuery.getAllRows();
        for (DBQueryRow dBQueryRow : allRows) {
            DBRow get = dBQueryRow.get(this);
            results.add(get == null ? null : fieldProp.getDefinition().rawJavaValue(get));
        }
        return results;
    }

    public boolean hasConditionsSet() {
        List<PropertyWrapper> props = this.getWrapper().getPropertyWrappers();
        for (PropertyWrapper prop : props) {
            Object qdt;
            if (!prop.isColumn() || ((QueryableDatatype)(qdt = prop.getQueryableDatatype())).getOperator() == null) continue;
            return true;
        }
        return false;
    }

    protected List<PropertyWrapperDefinition> getReturnColumns() {
        return this.returnColumns;
    }

    protected void setReturnColumns(List<PropertyWrapperDefinition> returnColumns) {
        this.returnColumns = returnColumns;
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        @Override
        public int compare(Class<?> first, Class<?> second) {
            String firstCanonicalName = first.getCanonicalName();
            String secondCanonicalName = second.getCanonicalName();
            if (firstCanonicalName != null && secondCanonicalName != null) {
                return firstCanonicalName.compareTo(secondCanonicalName);
            }
            return first.getSimpleName().compareTo(second.getSimpleName());
        }
    }
}

