/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBQuery;
import nz.co.gregs.dbvolution.DBQueryRow;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.columns.ColumnProvider;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.UnableToAccessDBReportFieldException;
import nz.co.gregs.dbvolution.exceptions.UnableToInstantiateDBReportSubclassException;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class DBReport
extends RowDefinition {
    private static final long serialVersionUID = 1L;
    private ColumnProvider[] sortColumns = new ColumnProvider[0];

    public static <A extends DBReport> List<A> getAllRows(DBDatabase database, A exampleReport) throws SQLException {
        DBQuery query = DBReport.setUpQuery(database, exampleReport, new DBRow[0]);
        ArrayList<A> reportRows = new ArrayList<A>();
        query.setBlankQueryAllowed(true);
        List<DBQueryRow> allRows = query.getAllRows();
        for (DBQueryRow row : allRows) {
            reportRows.add(DBReport.getReportInstance(exampleReport, row));
        }
        return reportRows;
    }

    public static <A extends DBReport> List<A> getRows(DBDatabase database, A exampleReport, DBRow ... rows) throws SQLException {
        DBQuery query = DBReport.setUpQuery(database, exampleReport, rows);
        ArrayList<A> reportRows = new ArrayList<A>();
        List<DBQueryRow> allRows = query.getAllRows();
        for (DBQueryRow row : allRows) {
            reportRows.add(DBReport.getReportInstance(exampleReport, row));
        }
        return reportRows;
    }

    public static <A extends DBReport> String getSQLForQuery(DBDatabase database, A exampleReport, DBRow ... rows) throws SQLException {
        DBQuery query = DBReport.setUpQuery(database, exampleReport, rows);
        return query.getSQLForQuery();
    }

    public static String getSQLForCount(DBDatabase database, DBReport exampleReport, DBRow ... rows) throws SQLException {
        DBQuery query = DBReport.setUpQuery(database, exampleReport, rows);
        return query.getSQLForCount();
    }

    public static Long count(DBDatabase database, DBReport exampleReport, DBRow ... rows) throws SQLException {
        DBQuery setUpQuery = DBReport.setUpQuery(database, exampleReport, rows);
        return setUpQuery.count();
    }

    public DBReport setSortOrder(ColumnProvider ... columns) {
        this.sortColumns = new ColumnProvider[columns.length];
        System.arraycopy(columns, 0, this.getSortColumns(), 0, columns.length);
        return this;
    }

    public DBReport setSortOrder(QueryableDatatype ... columns) {
        ArrayList<ColumnProvider> columnProviders = new ArrayList<ColumnProvider>();
        for (QueryableDatatype qdt : columns) {
            DBExpression expr = this.column(qdt);
            if (!(expr instanceof ColumnProvider)) continue;
            columnProviders.add((ColumnProvider)((Object)expr));
        }
        this.sortColumns = columnProviders.toArray(new ColumnProvider[0]);
        return this;
    }

    private static <A extends DBReport> DBQuery setUpQuery(DBDatabase database, A exampleReport, DBRow[] rows) {
        DBQuery query = database.getDBQuery(new DBRow[0]);
        DBReport.addTablesAndExpressions(query, exampleReport);
        query.addExtraExamples(rows);
        query.setSortOrder(exampleReport.getSortColumns());
        return query;
    }

    private static <A extends DBReport> void addTablesAndExpressions(DBQuery query, A exampleReport) {
        Field[] fields = exampleReport.getClass().getFields();
        if (fields.length == 0) {
            throw new UnableToAccessDBReportFieldException(exampleReport, null, null);
        }
        for (Field field : fields) {
            try {
                Object value = field.get(exampleReport);
                if (value != null && DBRow.class.isAssignableFrom(value.getClass())) {
                    if (!(value instanceof DBRow)) continue;
                    DBRow dbRow = (DBRow)value;
                    dbRow.removeAllFieldsFromResults();
                    query.add(dbRow);
                    continue;
                }
                if (value == null || !QueryableDatatype.class.isAssignableFrom(value.getClass()) || !(value instanceof QueryableDatatype) || !((QueryableDatatype)value).hasColumnExpression()) continue;
                DBExpression columnExpression = ((QueryableDatatype)value).getColumnExpression();
                query.addExpressionColumn(value, columnExpression);
                if (columnExpression.isAggregator()) continue;
                query.addGroupByColumn(value, columnExpression);
            }
            catch (IllegalArgumentException ex) {
                throw new UnableToAccessDBReportFieldException(exampleReport, field, ex);
            }
            catch (IllegalAccessException ex) {
                throw new UnableToAccessDBReportFieldException(exampleReport, field, ex);
            }
        }
    }

    private static <A extends DBReport> A getReportInstance(A exampleReport, DBQueryRow row) {
        try {
            Field[] fields;
            DBReport newReport = (DBReport)exampleReport.getClass().newInstance();
            for (Field field : fields = exampleReport.getClass().getFields()) {
                try {
                    Object value = field.get(exampleReport);
                    if (value != null && DBRow.class.isAssignableFrom(value.getClass())) {
                        if (!(value instanceof DBRow)) continue;
                        DBRow gotDefinedRow = row.get((DBRow)value);
                        field.set(newReport, gotDefinedRow);
                        continue;
                    }
                    if (value == null || !QueryableDatatype.class.isAssignableFrom(value.getClass()) || !(value instanceof QueryableDatatype) || !((QueryableDatatype)value).hasColumnExpression()) continue;
                    field.set(newReport, row.getExpressionColumnValue(value));
                }
                catch (IllegalArgumentException ex) {
                    throw new UnableToAccessDBReportFieldException(exampleReport, field, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnableToAccessDBReportFieldException(exampleReport, field, ex);
                }
            }
            return (A)newReport;
        }
        catch (InstantiationException ex) {
            throw new UnableToInstantiateDBReportSubclassException(exampleReport, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnableToInstantiateDBReportSubclassException(exampleReport, ex);
        }
    }

    protected ColumnProvider[] getSortColumns() {
        return this.sortColumns;
    }
}

