/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JFrame;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBQueryRow;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.columns.ColumnProvider;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.AccidentalBlankQueryException;
import nz.co.gregs.dbvolution.exceptions.AccidentalCartesianJoinException;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.exceptions.FailedToSetPropertyValueOnRowDefinition;
import nz.co.gregs.dbvolution.exceptions.IncorrectRowProviderInstanceSuppliedException;
import nz.co.gregs.dbvolution.exceptions.UnableToInstantiateDBRowSubclassException;
import nz.co.gregs.dbvolution.exceptions.UnexpectedNumberOfRowsException;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.query.QueryGraph;
import nz.co.gregs.dbvolution.query.QueryGraphNode;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.query.RowDefinition;
import org.apache.commons.collections15.Transformer;

public class DBQuery {
    private static final int COUNT_QUERY = 1;
    private static final int SELECT_QUERY = 0;
    private final DBDatabase database;
    private final List<DBRow> allQueryTables;
    private final List<DBRow> requiredQueryTables;
    private final List<DBRow> optionalQueryTables;
    private final QueryOptions options = new QueryOptions();
    private final List<DBRow> extraExamples = new ArrayList<DBRow>();
    private final List<BooleanExpression> conditions = new ArrayList<BooleanExpression>();
    private final Map<Object, DBExpression> expressionColumns = new LinkedHashMap<Object, DBExpression>();
    private final Map<Object, DBExpression> dbReportGroupByColumns = new LinkedHashMap<Object, DBExpression>();
    private final Map<Class<?>, Map<String, DBRow>> existingInstances = new HashMap();
    private String resultSQL;
    private QueryGraph queryGraph;
    private List<DBQueryRow> results;
    private String rawSQLClause = "";
    private Integer resultsRowLimit = -1;
    private Integer resultsPageIndex = 0;
    private JFrame queryGraphFrame = null;
    private ColumnProvider[] sortOrderColumns;
    private List<PropertyWrapper> sortOrder = null;

    private DBQuery(DBDatabase database) {
        this.requiredQueryTables = new ArrayList<DBRow>();
        this.optionalQueryTables = new ArrayList<DBRow>();
        this.allQueryTables = new ArrayList<DBRow>();
        this.database = database;
        this.blankResults();
    }

    static DBQuery getInstance(DBDatabase database, DBRow ... examples) {
        DBQuery dbQuery = new DBQuery(database);
        for (DBRow example : examples) {
            dbQuery.add(example);
        }
        return dbQuery;
    }

    public DBQuery add(DBRow ... tables) {
        for (DBRow table : tables) {
            this.requiredQueryTables.add(table);
            this.allQueryTables.add(table);
            this.blankResults();
        }
        return this;
    }

    public DBQuery add(List<DBRow> tables) {
        for (DBRow table : tables) {
            this.requiredQueryTables.add(table);
            this.allQueryTables.add(table);
            this.blankResults();
        }
        return this;
    }

    public DBQuery addOptional(DBRow ... tables) {
        for (DBRow table : tables) {
            this.optionalQueryTables.add(table);
            this.allQueryTables.add(table);
            this.blankResults();
        }
        return this;
    }

    public DBQuery remove(DBRow ... tables) {
        for (DBRow table : tables) {
            Iterator<DBRow> iterator = this.allQueryTables.iterator();
            while (iterator.hasNext()) {
                DBRow qtab = iterator.next();
                if (!qtab.isPeerOf(table)) continue;
                this.requiredQueryTables.remove(qtab);
                this.optionalQueryTables.remove(qtab);
                iterator.remove();
            }
        }
        this.blankResults();
        return this;
    }

    public String getSQLForQuery() {
        return this.getSQLForQuery(0);
    }

    String getANSIJoinClause(DBDatabase database, QueryState queryState, DBRow newTable, List<DBRow> previousTables) {
        String sqlToReturn;
        DBRow firstTable;
        ArrayList<String> joinClauses = new ArrayList<String>();
        ArrayList<String> conditionClauses = new ArrayList<String>();
        String lineSep = System.getProperty("line.separator");
        DBDefinition defn = database.getDefinition();
        boolean isLeftOuterJoin = false;
        boolean isFullOuterJoin = false;
        if (this.requiredQueryTables.isEmpty() && this.optionalQueryTables.size() == this.allQueryTables.size()) {
            isFullOuterJoin = true;
        } else if (this.optionalQueryTables.contains(newTable)) {
            isLeftOuterJoin = true;
        }
        for (DBRow otherTable : previousTables) {
            queryState.remainingExpressions.addAll(newTable.getRelationshipsAsBooleanExpressions(database, otherTable, this.options));
        }
        List<String> newTableConditions = newTable.getWhereClausesWithAliases(database);
        if (this.requiredQueryTables.contains(newTable)) {
            queryState.addRequiredConditions(newTableConditions);
        } else {
            conditionClauses.addAll(newTableConditions);
        }
        if (previousTables.size() == 1 && !this.requiredQueryTables.contains(firstTable = previousTables.get(0))) {
            List<String> firstTableConditions = firstTable.getWhereClausesWithAliases(database);
            conditionClauses.addAll(firstTableConditions);
        }
        if (previousTables.size() > 0) {
            for (BooleanExpression expr : queryState.getRemainingExpressions()) {
                HashSet<DBRow> tablesInvolved = new HashSet<DBRow>(expr.getTablesInvolved());
                if (tablesInvolved.contains(newTable)) {
                    tablesInvolved.remove(newTable);
                }
                if (tablesInvolved.size() > previousTables.size() || !previousTables.containsAll(tablesInvolved)) continue;
                if (expr.isRelationship()) {
                    joinClauses.add(expr.toSQLString(database));
                } else if (this.requiredQueryTables.containsAll(tablesInvolved)) {
                    queryState.addRequiredCondition(expr.toSQLString(database));
                } else {
                    conditionClauses.add(expr.toSQLString(database));
                }
                queryState.consumeExpression(expr);
            }
        }
        if (previousTables.isEmpty()) {
            sqlToReturn = " " + defn.formatTableName(newTable) + defn.beginTableAlias() + defn.getTableAlias(newTable) + defn.endTableAlias();
        } else {
            sqlToReturn = isFullOuterJoin ? lineSep + defn.beginFullOuterJoin() : (isLeftOuterJoin ? lineSep + defn.beginLeftOuterJoin() : lineSep + defn.beginInnerJoin());
            sqlToReturn = sqlToReturn + defn.formatTableName(newTable) + defn.beginTableAlias() + defn.getTableAlias(newTable) + defn.endTableAlias();
            sqlToReturn = sqlToReturn + defn.beginOnClause();
            if (!conditionClauses.isEmpty()) {
                if (!joinClauses.isEmpty()) {
                    sqlToReturn = sqlToReturn + "(";
                }
                sqlToReturn = sqlToReturn + this.mergeConditionsIntoSQLClause(conditionClauses, defn);
            }
            if (!joinClauses.isEmpty()) {
                if (!conditionClauses.isEmpty()) {
                    sqlToReturn = sqlToReturn + ")" + defn.beginAndLine() + "(";
                }
                String separator = "";
                for (String join : joinClauses) {
                    sqlToReturn = sqlToReturn + separator + join;
                    separator = defn.beginJoinClauseLine(this.options);
                }
                if (!conditionClauses.isEmpty()) {
                    sqlToReturn = sqlToReturn + ")";
                }
            }
            if (conditionClauses.isEmpty() && joinClauses.isEmpty()) {
                sqlToReturn = sqlToReturn + defn.getWhereClauseBeginningCondition(this.options);
            }
            sqlToReturn = sqlToReturn + defn.endOnClause();
        }
        return sqlToReturn;
    }

    private String mergeConditionsIntoSQLClause(List<String> conditionClauses, DBDefinition defn) {
        String separator = "";
        String sqlToReturn = "";
        for (String cond : conditionClauses) {
            sqlToReturn = sqlToReturn + separator + cond;
            separator = defn.beginConditionClauseLine(this.options);
        }
        return sqlToReturn;
    }

    private String getSQLForQuery(int queryType) {
        String sqlString = "";
        if (this.allQueryTables.size() > 0) {
            String string;
            List<DBRow> sortedQueryTables;
            QueryState queryState = new QueryState(this, this.database);
            this.initialiseQueryGraph();
            queryState.setGraph(this.queryGraph);
            DBDefinition defn = this.database.getDefinition();
            StringBuilder selectClause = new StringBuilder().append(defn.beginSelectStatement());
            int columnIndex = 1;
            String groupByColumnIndex = defn.beginGroupByClause();
            String groupByColumnIndexSeparator = "";
            HashMap<PropertyWrapperDefinition, Integer> indexesOfSelectedColumns = new HashMap<PropertyWrapperDefinition, Integer>();
            HashMap<DBExpression, Integer> indexesOfSelectedExpressions = new HashMap<DBExpression, Integer>();
            StringBuilder fromClause = new StringBuilder().append(defn.beginFromClause());
            ArrayList<DBRow> joinedTables = new ArrayList<DBRow>();
            String initialWhereClause = defn.beginWhereClause() + defn.getWhereClauseBeginningCondition(this.options);
            StringBuilder whereClause = new StringBuilder(initialWhereClause);
            StringBuilder groupByClause = new StringBuilder().append(defn.beginGroupByClause());
            String lineSep = System.getProperty("line.separator");
            List<DBRow> list = sortedQueryTables = this.options.isCartesianJoinAllowed() ? this.queryGraph.toListIncludingCartesian() : this.queryGraph.toList();
            if (this.options.getRowLimit() > 0) {
                selectClause.append(defn.getLimitRowsSubClauseDuringSelectClause(this.options));
            }
            String separator = "";
            String colSep = defn.getStartingSelectSubClauseSeparator();
            String groupByColSep = "";
            for (DBRow tabRow : sortedQueryTables) {
                String tableName = tabRow.getTableName();
                List<PropertyWrapper> list2 = tabRow.getSelectedProperties();
                for (PropertyWrapper propWrapper : list2) {
                    selectClause.append(colSep).append(propWrapper.getSelectableName(this.database)).append(" ").append(propWrapper.getColumnAlias(this.database));
                    colSep = defn.getSubsequentSelectSubClauseSeparator() + lineSep;
                    groupByColumnIndex = groupByColumnIndex + groupByColumnIndexSeparator + columnIndex;
                    groupByColumnIndexSeparator = defn.getSubsequentGroupBySubClauseSeparator();
                    indexesOfSelectedColumns.put(propWrapper.getDefinition(), columnIndex);
                    ++columnIndex;
                }
                if (!this.options.isUseANSISyntax()) {
                    fromClause.append(separator).append(tableName);
                } else {
                    fromClause.append(this.getANSIJoinClause(this.database, queryState, tabRow, joinedTables));
                }
                joinedTables.add(tabRow);
                if (!this.options.isUseANSISyntax()) {
                    List<String> tabRowCriteria = tabRow.getWhereClausesWithAliases(this.database);
                    if (tabRowCriteria != null && !tabRowCriteria.isEmpty()) {
                        for (String clause : tabRowCriteria) {
                            whereClause.append(lineSep).append(defn.beginConditionClauseLine(this.options)).append(clause);
                        }
                    }
                    this.getNonANSIJoin(tabRow, whereClause, defn, joinedTables, lineSep);
                }
                separator = ", " + lineSep;
            }
            String conditionsAsSQLClause = this.mergeConditionsIntoSQLClause(queryState.getRequiredConditions(), defn);
            if (!conditionsAsSQLClause.isEmpty()) {
                whereClause.append(defn.beginConditionClauseLine(this.options)).append(conditionsAsSQLClause);
            }
            for (DBRow dBRow : this.extraExamples) {
                List<String> extraCriteria = dBRow.getWhereClausesWithAliases(this.database);
                if (extraCriteria == null || extraCriteria.isEmpty()) continue;
                for (String clause : extraCriteria) {
                    whereClause.append(lineSep).append(defn.beginConditionClauseLine(this.options)).append(clause);
                }
            }
            for (BooleanExpression booleanExpression : queryState.getRemainingExpressions()) {
                whereClause.append(lineSep).append(defn.beginConditionClauseLine(this.options)).append("(").append(booleanExpression.toSQLString(this.database)).append(")");
                queryState.consumeExpression(booleanExpression);
            }
            for (Map.Entry entry : this.expressionColumns.entrySet()) {
                Object key = entry.getKey();
                DBExpression expression = (DBExpression)entry.getValue();
                selectClause.append(colSep).append(expression.toSQLString(this.database)).append(" ").append(defn.formatExpressionAlias(key));
                colSep = defn.getSubsequentSelectSubClauseSeparator() + lineSep;
                if (!expression.isAggregator()) {
                    groupByColumnIndex = groupByColumnIndex + groupByColumnIndexSeparator + columnIndex;
                    groupByColumnIndexSeparator = defn.getSubsequentGroupBySubClauseSeparator();
                }
                indexesOfSelectedExpressions.put(expression, columnIndex);
                ++columnIndex;
            }
            for (Map.Entry entry : this.dbReportGroupByColumns.entrySet()) {
                groupByClause.append(groupByColSep).append(((DBExpression)entry.getValue()).toSQLString(this.database));
                groupByColSep = defn.getSubsequentGroupBySubClauseSeparator() + lineSep;
            }
            boolean useColumnIndexGroupBy = defn.prefersIndexBasedGroupByClause();
            String string2 = string = this.rawSQLClause.isEmpty() ? "" : this.rawSQLClause + lineSep;
            if (whereClause.toString().equals(initialWhereClause) && string.isEmpty()) {
                whereClause = new StringBuilder("");
            }
            if (queryType == 0) {
                String groupByClauseFinal = this.dbReportGroupByColumns.size() > 0 ? (useColumnIndexGroupBy ? groupByColumnIndex : groupByClause.toString()) + lineSep : "";
                String orderByClauseFinal = this.getOrderByClause(indexesOfSelectedColumns, indexesOfSelectedExpressions);
                if (!orderByClauseFinal.trim().isEmpty()) {
                    orderByClauseFinal = orderByClauseFinal + lineSep;
                }
                sqlString = selectClause.append(lineSep).append((CharSequence)fromClause).append(lineSep).append((CharSequence)whereClause).append(lineSep).append(string).append(groupByClauseFinal).append(orderByClauseFinal).append(this.options.getRowLimit() > 0 ? defn.getLimitRowsSubClauseAfterWhereClause(this.options) : "").append(defn.endSQLStatement()).toString();
            } else if (queryType == 1) {
                sqlString = defn.beginSelectStatement() + defn.countStarClause() + lineSep + fromClause + lineSep + whereClause + lineSep + string + lineSep + defn.endSQLStatement();
            }
        }
        return sqlString;
    }

    private void getNonANSIJoin(DBRow tabRow, StringBuilder whereClause, DBDefinition defn, List<DBRow> otherTables, String lineSep) {
        for (BooleanExpression rel : tabRow.getAdHocRelationships()) {
            whereClause.append(defn.beginConditionClauseLine(this.options)).append("(").append(rel.toSQLString(this.database)).append(")");
        }
        for (DBRow otherTab : otherTables) {
            List<PropertyWrapper> otherTableFks = otherTab.getForeignKeyPropertyWrappers();
            for (PropertyWrapper otherTableFk : otherTableFks) {
                Class<? extends DBRow> fkReferencedClass = otherTableFk.referencedClass();
                if (!fkReferencedClass.isAssignableFrom(tabRow.getClass())) continue;
                String formattedForeignKey = defn.formatTableAliasAndColumnName(otherTab, otherTableFk.columnName());
                String formattedReferencedColumn = defn.formatTableAliasAndColumnName(tabRow, otherTableFk.referencedColumnName());
                whereClause.append(lineSep).append(defn.beginConditionClauseLine(this.options)).append("(").append(formattedForeignKey).append(defn.getEqualsComparator()).append(formattedReferencedColumn).append(")");
            }
        }
    }

    public String getSQLForCount() {
        return this.getSQLForQuery(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBQueryRow> getAllRows() throws SQLException, AccidentalBlankQueryException, AccidentalCartesianJoinException {
        this.prepareForQuery();
        if (this.requiredQueryTables.isEmpty() && this.optionalQueryTables.isEmpty()) {
            throw new AccidentalBlankQueryException();
        }
        if (!this.options.isBlankQueryAllowed() && this.willCreateBlankQuery() && this.rawSQLClause.isEmpty()) {
            throw new AccidentalBlankQueryException();
        }
        if (!this.options.isCartesianJoinAllowed() && this.requiredQueryTables.size() + this.optionalQueryTables.size() > 1 && this.queryGraph.willCreateCartesianJoin()) {
            throw new AccidentalCartesianJoinException(this.resultSQL);
        }
        DBStatement dbStatement = this.database.getDBStatement();
        try {
            ResultSet resultSet = this.getResultSetForSQL(dbStatement);
            try {
                while (resultSet.next()) {
                    DBQueryRow queryRow = new DBQueryRow();
                    this.setExpressionColumns(resultSet, queryRow);
                    this.setQueryRowFromResultSet(resultSet, queryRow, this.dbReportGroupByColumns.size() > 0);
                    this.results.add(queryRow);
                }
            }
            finally {
                resultSet.close();
            }
        }
        finally {
            dbStatement.close();
        }
        return this.results;
    }

    protected ResultSet getResultSetForSQL(DBStatement dbStatement) throws SQLException {
        return dbStatement.executeQuery(this.resultSQL);
    }

    protected void setQueryRowFromResultSet(ResultSet resultSet, DBQueryRow queryRow, boolean isGroupedQuery) throws SQLException, UnableToInstantiateDBRowSubclassException {
        for (DBRow tableRow : this.allQueryTables) {
            Object newInstance = DBRow.getDBRow(tableRow.getClass());
            this.setFieldsFromColumns(tableRow, (DBRow)newInstance, resultSet);
            ((DBRow)newInstance).setDefined();
            Map<String, DBRow> existingInstancesOfThisTableRow = this.existingInstances.get(tableRow.getClass());
            existingInstancesOfThisTableRow = this.setExistingInstancesForTable(existingInstancesOfThisTableRow, (DBRow)newInstance);
            if (((DBRow)newInstance).isEmptyRow().booleanValue()) {
                queryRow.put(newInstance.getClass(), null);
                continue;
            }
            if (isGroupedQuery) {
                queryRow.put(newInstance.getClass(), newInstance);
                continue;
            }
            DBRow existingInstance = this.getOrSetExistingInstanceForRow((DBRow)newInstance, existingInstancesOfThisTableRow);
            queryRow.put(existingInstance.getClass(), existingInstance);
        }
    }

    protected DBRow getOrSetExistingInstanceForRow(DBRow newInstance, Map<String, DBRow> existingInstancesOfThisTableRow) {
        Object qdt;
        DBRow existingInstance = newInstance;
        PropertyWrapper primaryKey = newInstance.getPrimaryKeyPropertyWrapper();
        if (primaryKey != null && (qdt = primaryKey.getQueryableDatatype()) != null && (existingInstance = existingInstancesOfThisTableRow.get(((QueryableDatatype)qdt).toSQLString(this.database))) == null) {
            existingInstance = newInstance;
            existingInstancesOfThisTableRow.put(((QueryableDatatype)qdt).toSQLString(this.database), existingInstance);
        }
        return existingInstance;
    }

    protected Map<String, DBRow> setExistingInstancesForTable(Map<String, DBRow> existingInstancesOfThisTableRow, DBRow newInstance) {
        Map<String, DBRow> hashMap = existingInstancesOfThisTableRow;
        if (hashMap == null) {
            hashMap = new HashMap<String, DBRow>();
        }
        this.existingInstances.put(newInstance.getClass(), hashMap);
        return hashMap;
    }

    protected void setFieldsFromColumns(DBRow oldInstance, DBRow newInstance, ResultSet resultSet) throws SQLException {
        List<PropertyWrapper> selectedProperties = oldInstance.getSelectedProperties();
        List<PropertyWrapper> newProperties = newInstance.getPropertyWrappers();
        for (PropertyWrapper newProp : newProperties) {
            Object qdt = newProp.getQueryableDatatype();
            for (PropertyWrapper propertyWrapper : selectedProperties) {
                if (!propertyWrapper.getDefinition().equals(newProp.getDefinition())) continue;
                String resultSetColumnName = newProp.getColumnAlias(this.database);
                ((QueryableDatatype)qdt).setFromResultSet(this.database, resultSet, resultSetColumnName);
                if (!newInstance.isEmptyRow().booleanValue() || ((QueryableDatatype)qdt).isNull()) continue;
                newInstance.setEmptyRow(false);
            }
            newProp.setQueryableDatatype((QueryableDatatype)qdt);
        }
    }

    protected void setExpressionColumns(ResultSet resultSet, DBQueryRow queryRow) throws SQLException {
        for (Map.Entry<Object, DBExpression> entry : this.expressionColumns.entrySet()) {
            String expressionAlias = this.database.getDefinition().formatExpressionAlias(entry.getKey());
            QueryableDatatype expressionQDT = entry.getValue().getQueryableDatatypeForExpressionValue();
            expressionQDT.setFromResultSet(this.database, resultSet, expressionAlias);
            queryRow.addExpressionColumnValue(entry.getKey(), expressionQDT);
        }
    }

    private void prepareForQuery() throws SQLException {
        this.results = new ArrayList<DBQueryRow>();
        this.resultsRowLimit = this.options.getRowLimit();
        this.resultsPageIndex = this.options.getPageIndex();
        this.resultSQL = this.getSQLForQuery();
    }

    public <R extends DBRow> R getOnlyInstanceOf(R exemplar) throws SQLException, UnexpectedNumberOfRowsException {
        List<R> allInstancesFound = this.getAllInstancesOf(exemplar, 1L);
        return allInstancesFound.get(0);
    }

    public <R extends DBRow> List<R> getAllInstancesOf(R exemplar, long expected) throws SQLException, UnexpectedNumberOfRowsException {
        List<R> allInstancesFound = this.getAllInstancesOf(exemplar);
        int actual = allInstancesFound.size();
        if ((long)actual > expected) {
            throw new UnexpectedNumberOfRowsException(expected, actual, "Too Many Results: expected " + expected + ", actually got " + actual);
        }
        if ((long)actual < expected) {
            throw new UnexpectedNumberOfRowsException(expected, actual, "Too Few Results: expected " + expected + ", actually got " + actual);
        }
        return allInstancesFound;
    }

    private boolean needsResults() {
        return this.results == null || this.results.isEmpty() || this.resultSQL == null || !this.resultsPageIndex.equals(this.options.getPageIndex()) || !this.resultsRowLimit.equals(this.options.getRowLimit()) || !this.resultSQL.equals(this.getSQLForQuery());
    }

    public <R extends DBRow> List<R> getAllInstancesOf(R exemplar) throws SQLException {
        ArrayList<R> arrayList = new ArrayList<R>();
        if (this.needsResults()) {
            this.getAllRows();
        }
        if (!this.results.isEmpty()) {
            for (DBQueryRow row : this.results) {
                R found = row.get(exemplar);
                if (found == null || arrayList.contains(found)) continue;
                arrayList.add(found);
            }
        }
        return arrayList;
    }

    public void print() throws SQLException {
        this.print(System.out);
    }

    public void print(PrintStream ps) throws SQLException {
        if (this.needsResults()) {
            this.getAllRows();
        }
        for (DBQueryRow row : this.results) {
            String tableSeparator = "";
            for (DBRow tab : this.allQueryTables) {
                ps.print(tableSeparator);
                DBRow rowPart = row.get(tab);
                if (rowPart != null) {
                    String rowPartStr = rowPart.toString();
                    ps.print(rowPartStr);
                }
                tableSeparator = " | ";
            }
            ps.println();
        }
    }

    public void printAllDataColumns(PrintStream printStream) throws SQLException {
        if (this.needsResults()) {
            this.getAllRows();
        }
        for (DBQueryRow row : this.results) {
            for (DBRow tab : this.allQueryTables) {
                DBRow rowPart = row.get(tab);
                if (rowPart == null) continue;
                String rowPartStr = rowPart.toString();
                printStream.print(rowPartStr);
            }
            printStream.println();
        }
    }

    public void printAllPrimaryKeys(PrintStream ps) throws SQLException {
        if (this.needsResults()) {
            this.getAllRows();
        }
        for (DBQueryRow row : this.results) {
            for (DBRow tab : this.allQueryTables) {
                Object primaryKey;
                DBRow rowPart = row.get(tab);
                if (rowPart == null || (primaryKey = rowPart.getPrimaryKey()) == null) continue;
                String rowPartStr = ((QueryableDatatype)primaryKey).toSQLString(this.database);
                ps.print(" " + rowPart.getPrimaryKeyColumnName() + ": " + rowPartStr);
            }
            ps.println();
        }
    }

    public DBQuery clear() {
        this.requiredQueryTables.clear();
        this.optionalQueryTables.clear();
        this.allQueryTables.clear();
        this.conditions.clear();
        this.extraExamples.clear();
        this.blankResults();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long count() throws SQLException {
        if (this.results != null) {
            return this.results.size();
        }
        Long result = 0L;
        DBStatement dbStatement = this.database.getDBStatement();
        try {
            String sqlForCount = this.getSQLForCount();
            ResultSet resultSet = dbStatement.executeQuery(sqlForCount);
            try {
                while (resultSet.next()) {
                    result = resultSet.getLong(1);
                }
            }
            finally {
                resultSet.close();
            }
        }
        finally {
            dbStatement.close();
        }
        return result;
    }

    public boolean willCreateBlankQuery() {
        boolean willCreateBlankQuery = true;
        for (DBRow table : this.allQueryTables) {
            willCreateBlankQuery = willCreateBlankQuery && table.willCreateBlankQuery(this.database);
        }
        for (DBRow table : this.extraExamples) {
            willCreateBlankQuery = willCreateBlankQuery && table.willCreateBlankQuery(this.database);
        }
        return willCreateBlankQuery && this.conditions.isEmpty();
    }

    public DBQuery setRowLimit(int maximumNumberOfRowsReturned) {
        int limit = maximumNumberOfRowsReturned;
        if (maximumNumberOfRowsReturned < 0) {
            limit = 0;
        }
        this.options.setRowLimit(limit);
        this.blankResults();
        return this;
    }

    public DBQuery clearRowLimit() {
        this.options.setRowLimit(-1);
        this.blankResults();
        return this;
    }

    public DBQuery setSortOrder(ColumnProvider ... sortColumns) {
        this.blankResults();
        this.sortOrderColumns = Arrays.copyOf(sortColumns, sortColumns.length);
        this.sortOrder = new ArrayList<PropertyWrapper>();
        for (ColumnProvider col : sortColumns) {
            PropertyWrapper prop = col.getColumn().getPropertyWrapper();
            if (prop == null) continue;
            this.sortOrder.add(prop);
        }
        return this;
    }

    public DBQuery addToSortOrder(ColumnProvider ... sortColumns) {
        if (sortColumns != null) {
            this.blankResults();
            LinkedList<ColumnProvider> sortOrderColumnsList = new LinkedList<ColumnProvider>();
            if (this.sortOrderColumns != null) {
                sortOrderColumnsList.addAll(Arrays.asList(this.sortOrderColumns));
            }
            sortOrderColumnsList.addAll(Arrays.asList(sortColumns));
            return this.setSortOrder(sortOrderColumnsList.toArray(new ColumnProvider[0]));
        }
        return this;
    }

    public DBQuery addToSortOrder(DBExpression ... sortColumns) {
        for (DBExpression dBExpression : sortColumns) {
            if (!(dBExpression instanceof ColumnProvider)) continue;
            this.addToSortOrder((ColumnProvider)((Object)dBExpression));
        }
        return this;
    }

    public DBQuery clearSortOrder() {
        this.sortOrder = null;
        this.sortOrderColumns = null;
        return this;
    }

    private String getOrderByClause(Map<PropertyWrapperDefinition, Integer> indexesOfSelectedProperties, Map<DBExpression, Integer> IndexesOfSelectedExpressions) {
        DBDefinition defn = this.database.getDefinition();
        boolean prefersIndexBasedOrderByClause = defn.prefersIndexBasedOrderByClause();
        if (this.sortOrderColumns != null && this.sortOrderColumns.length > 0) {
            StringBuilder orderByClause = new StringBuilder(defn.beginOrderByClause());
            String sortSeparator = defn.getStartingOrderByClauseSeparator();
            for (ColumnProvider column : this.sortOrderColumns) {
                DBRow adapteeDBRow;
                String dbColumnName;
                PropertyWrapper prop = column.getColumn().getPropertyWrapper();
                Object qdt = prop.getQueryableDatatype();
                PropertyWrapperDefinition propDefn = prop.getDefinition();
                if (prefersIndexBasedOrderByClause) {
                    Integer columnIndex = indexesOfSelectedProperties.get(propDefn);
                    if (columnIndex == null) {
                        columnIndex = IndexesOfSelectedExpressions.get(qdt);
                    }
                    if (columnIndex == null) {
                        DBExpression columnExpression = ((QueryableDatatype)qdt).getColumnExpression();
                        columnIndex = IndexesOfSelectedExpressions.get(columnExpression);
                    }
                    orderByClause.append(sortSeparator).append(columnIndex).append(defn.getOrderByDirectionClause(((QueryableDatatype)qdt).getSortOrder()));
                    sortSeparator = defn.getSubsequentOrderByClauseSeparator();
                    continue;
                }
                if (((QueryableDatatype)qdt).hasColumnExpression()) {
                    String dbColumnName2 = ((QueryableDatatype)qdt).getColumnExpression().toSQLString(this.database);
                    if (dbColumnName2 == null) continue;
                    orderByClause.append(sortSeparator).append(dbColumnName2).append(defn.getOrderByDirectionClause(((QueryableDatatype)qdt).getSortOrder()));
                    sortSeparator = defn.getSubsequentOrderByClauseSeparator();
                    continue;
                }
                RowDefinition possibleDBRow = prop.getRowDefinitionInstanceWrapper().adapteeRowDefinition();
                if (possibleDBRow == null || !DBRow.class.isAssignableFrom(possibleDBRow.getClass()) || (dbColumnName = defn.formatTableAliasAndColumnName(adapteeDBRow = (DBRow)possibleDBRow, prop.columnName())) == null) continue;
                orderByClause.append(sortSeparator).append(dbColumnName).append(defn.getOrderByDirectionClause(((QueryableDatatype)qdt).getSortOrder()));
                sortSeparator = defn.getSubsequentOrderByClauseSeparator();
            }
            orderByClause.append(defn.endOrderByClause());
            return orderByClause.toString();
        }
        return "";
    }

    public DBQuery setBlankQueryAllowed(boolean allow) {
        this.options.setBlankQueryAllowed(allow);
        return this;
    }

    public DBQuery setCartesianJoinsAllowed(boolean allow) {
        this.options.setCartesianJoinAllowed(allow);
        return this;
    }

    public List<DBQueryRow> getAllRows(long expectedRows) throws UnexpectedNumberOfRowsException, SQLException {
        List<DBQueryRow> allRows = this.getAllRows();
        if ((long)allRows.size() != expectedRows) {
            throw new UnexpectedNumberOfRowsException(expectedRows, allRows.size());
        }
        return allRows;
    }

    public boolean isUseANSISyntax() {
        return this.options.isUseANSISyntax();
    }

    public DBQuery setUseANSISyntax(boolean useANSISyntax) {
        this.options.setUseANSISyntax(useANSISyntax);
        return this;
    }

    public SortedSet<DBRow> getRelatedTables() throws UnableToInstantiateDBRowSubclassException {
        TreeSet<Class> resultClasses = new TreeSet<Class>(new DBRowClassNameComparator());
        TreeSet<DBRow> result = new TreeSet<DBRow>(new DBRowNameComparator());
        for (DBRow table : this.allQueryTables) {
            SortedSet<Class<? extends DBRow>> allRelatedTables = table.getRelatedTables();
            for (Class clazz : allRelatedTables) {
                try {
                    if (!resultClasses.add(clazz)) continue;
                    result.add((DBRow)clazz.newInstance());
                }
                catch (IllegalAccessException ex) {
                    throw new UnableToInstantiateDBRowSubclassException(clazz, (Throwable)ex);
                }
                catch (InstantiationException ex) {
                    throw new UnableToInstantiateDBRowSubclassException(clazz, (Throwable)ex);
                }
            }
        }
        return result;
    }

    public SortedSet<DBRow> getReferencedTables() {
        TreeSet<DBRow> result = new TreeSet<DBRow>(new DBRowNameComparator());
        for (DBRow table : this.allQueryTables) {
            SortedSet<Class<? extends DBRow>> allRelatedTables = table.getReferencedTables();
            for (Class clazz : allRelatedTables) {
                try {
                    result.add((DBRow)clazz.newInstance());
                }
                catch (InstantiationException ex) {
                    throw new UnableToInstantiateDBRowSubclassException(clazz, (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    throw new UnableToInstantiateDBRowSubclassException(clazz, (Throwable)ex);
                }
            }
        }
        return result;
    }

    public Set<DBRow> getAllConnectedTables() {
        SortedSet<DBRow> result = this.getReferencedTables();
        result.addAll(this.getRelatedTables());
        return result;
    }

    public DBQuery addAllConnectedTables() throws InstantiationException, IllegalAccessException {
        ArrayList tablesToAdd = new ArrayList();
        for (DBRow table : this.allQueryTables) {
            SortedSet<Class<? extends DBRow>> allConnectedTables = table.getAllConnectedTables();
            for (Class clazz : allConnectedTables) {
                tablesToAdd.add(clazz.newInstance());
            }
        }
        this.add(tablesToAdd.toArray(new DBRow[0]));
        return this;
    }

    public DBQuery addAllConnectedTablesAsOptional() throws InstantiationException, IllegalAccessException {
        HashSet<DBRow> tablesToAdd = new HashSet<DBRow>();
        ArrayList alreadyAddedClasses = new ArrayList();
        for (DBRow table : this.allQueryTables) {
            Class<?> aClass = table.getClass();
            alreadyAddedClasses.add(aClass);
        }
        for (DBRow table : this.allQueryTables) {
            SortedSet<Class<? extends DBRow>> allRelatedTables = table.getAllConnectedTables();
            for (Class clazz : allRelatedTables) {
                DBRow newInstance = (DBRow)clazz.newInstance();
                Class<?> newInstanceClass = newInstance.getClass();
                if (alreadyAddedClasses.contains(newInstanceClass)) continue;
                tablesToAdd.add(newInstance);
                alreadyAddedClasses.add(newInstanceClass);
            }
        }
        this.addOptional(tablesToAdd.toArray(new DBRow[0]));
        return this;
    }

    public DBQuery addAllConnectedTablesAsOptionalWithoutInternalRelations() throws InstantiationException, IllegalAccessException {
        HashSet<DBRow> tablesToAdd = new HashSet<DBRow>();
        ArrayList alreadyAddedClasses = new ArrayList();
        DBRow[] originalTables = this.allQueryTables.toArray(new DBRow[0]);
        for (DBRow table : this.allQueryTables) {
            Class<?> aClass = table.getClass();
            alreadyAddedClasses.add(aClass);
        }
        for (DBRow table : this.allQueryTables) {
            SortedSet<Class<? extends DBRow>> allRelatedTables = table.getAllConnectedTables();
            for (Class clazz : allRelatedTables) {
                DBRow newInstance = (DBRow)clazz.newInstance();
                Class<?> newInstanceClass = newInstance.getClass();
                if (alreadyAddedClasses.contains(newInstanceClass)) continue;
                newInstance.ignoreAllForeignKeysExceptFKsTo(originalTables);
                tablesToAdd.add(newInstance);
                alreadyAddedClasses.add(newInstanceClass);
            }
        }
        this.addOptional(tablesToAdd.toArray(new DBRow[0]));
        return this;
    }

    public List<DBQueryRow> getAllRowsContaining(DBRow instance) throws SQLException {
        if (this.needsResults()) {
            this.getAllRows();
        }
        ArrayList<DBQueryRow> returnList = new ArrayList<DBQueryRow>();
        for (DBQueryRow row : this.results) {
            if (row.get(instance) != instance) continue;
            returnList.add(row);
        }
        return returnList;
    }

    public List<DBQueryRow> getAllRowsForPage(Integer pageNumber) throws SQLException {
        int rowLimit = this.options.getRowLimit();
        if (this.database.supportsPaging(this.options)) {
            this.options.setPageIndex(pageNumber);
        } else {
            this.options.setRowLimit(-1);
        }
        if (this.needsResults()) {
            this.getAllRows();
            this.options.setRowLimit(rowLimit);
        }
        if (!this.database.supportsPaging(this.options)) {
            int startIndex = rowLimit * pageNumber;
            startIndex = startIndex < 0 ? 0 : startIndex;
            int stopIndex = rowLimit * (pageNumber + 1) - 1;
            int n = stopIndex = stopIndex >= this.results.size() ? this.results.size() - 1 : stopIndex;
            if (stopIndex - startIndex < 1) {
                return new ArrayList<DBQueryRow>();
            }
            return this.results.subList(startIndex, stopIndex);
        }
        return this.results;
    }

    public DBQuery addCondition(BooleanExpression condition) {
        this.conditions.add(condition);
        this.blankResults();
        return this;
    }

    public DBQuery clearConditions() {
        this.conditions.clear();
        this.blankResults();
        return this;
    }

    public DBQuery setToMatchAnyCondition() {
        this.options.setMatchAnyConditions();
        this.blankResults();
        return this;
    }

    public DBQuery setToMatchAnyRelationship() {
        this.options.setMatchAnyRelationship();
        this.blankResults();
        return this;
    }

    public DBQuery setToMatchAllRelationships() {
        this.options.setMatchAllRelationships();
        this.blankResults();
        return this;
    }

    public DBQuery setToMatchAllConditions() {
        this.options.setMatchAllConditions();
        this.blankResults();
        return this;
    }

    public DBQuery addOptionalIfNonspecific(DBRow exampleWithOrWithoutCriteria) {
        if (exampleWithOrWithoutCriteria.willCreateBlankQuery(this.database)) {
            this.addOptional(exampleWithOrWithoutCriteria);
        } else {
            this.add(exampleWithOrWithoutCriteria);
        }
        return this;
    }

    public DBQuery addOptionalIfNonspecific(DBRow ... examplesWithOrWithoutCriteria) {
        for (DBRow dBRow : examplesWithOrWithoutCriteria) {
            this.addOptionalIfNonspecific(dBRow);
        }
        return this;
    }

    public DBQuery addExpressionColumn(Object identifyingObject, DBExpression expressionToAdd) {
        this.expressionColumns.put(identifyingObject, expressionToAdd);
        this.blankResults();
        return this;
    }

    protected DBQuery addGroupByColumn(Object identifyingObject, DBExpression expressionToAdd) {
        this.dbReportGroupByColumns.put(identifyingObject, expressionToAdd);
        return this;
    }

    protected void refreshQuery() {
        this.blankResults();
    }

    void setRawSQL(String rawQuery) {
        this.rawSQLClause = rawQuery == null ? "" : " " + rawQuery + " ";
    }

    void addExtraExamples(DBRow ... extraExamples) {
        this.extraExamples.addAll(Arrays.asList(extraExamples));
        this.blankResults();
    }

    private void blankResults() {
        this.results = null;
        this.resultSQL = null;
        this.queryGraph = null;
    }

    public void displayQueryGraph() {
        this.initialiseQueryGraph();
        Graph<QueryGraphNode, DBExpression> jungGraph = this.queryGraph.getJungGraph();
        FRLayout layout = new FRLayout(jungGraph);
        layout.setSize(new Dimension(550, 400));
        VisualizationViewer vv = new VisualizationViewer((Layout)layout);
        vv.setPreferredSize(new Dimension(600, 480));
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.PICKING);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        RenderContext renderContext = vv.getRenderContext();
        renderContext.setEdgeLabelTransformer((Transformer)new QueryGraphEdgeLabelTransformer());
        renderContext.setVertexLabelTransformer((Transformer)new ToStringLabeller());
        renderContext.setEdgeLabelRenderer((EdgeLabelRenderer)new DefaultEdgeLabelRenderer(Color.BLUE, false));
        renderContext.setVertexFillPaintTransformer((Transformer)new QueryGraphVertexFillPaintTransformer());
        this.queryGraphFrame = new JFrame("DBQuery Graph");
        this.queryGraphFrame.setDefaultCloseOperation(2);
        this.queryGraphFrame.setResizable(true);
        this.queryGraphFrame.getContentPane().add((Component)vv);
        this.queryGraphFrame.pack();
        this.queryGraphFrame.setVisible(true);
    }

    private void initialiseQueryGraph() {
        if (this.queryGraph == null) {
            this.queryGraph = new QueryGraph(this.database, this.requiredQueryTables, this.getConditions(), this.options);
            this.queryGraph.addOptionalAndConnectToRelevant(this.database, this.optionalQueryTables, this.getConditions(), this.options);
        } else {
            this.queryGraph.clear();
            this.queryGraph.addAndConnectToRelevant(this.database, this.requiredQueryTables, this.getConditions(), this.options);
            this.queryGraph.addOptionalAndConnectToRelevant(this.database, this.optionalQueryTables, this.getConditions(), this.options);
        }
    }

    public void closeQueryGraph() {
        if (this.queryGraphFrame != null) {
            this.queryGraphFrame.setVisible(false);
            this.queryGraphFrame.dispose();
        }
    }

    protected List<BooleanExpression> getConditions() {
        return this.conditions;
    }

    public List<DBQueryRow> getDistinctCombinationsOfColumnValues(Object ... fieldsOfProvidedRows) throws AccidentalBlankQueryException, SQLException {
        DBRow copyDBRow;
        List<DBQueryRow> returnList = new ArrayList<DBQueryRow>();
        DBQuery distinctQuery = this.database.getDBQuery(new DBRow[0]);
        for (DBRow row : this.requiredQueryTables) {
            copyDBRow = DBRow.copyDBRow(row);
            copyDBRow.removeAllFieldsFromResults();
            distinctQuery.add(copyDBRow);
        }
        for (DBRow row : this.optionalQueryTables) {
            copyDBRow = DBRow.copyDBRow(row);
            copyDBRow.removeAllFieldsFromResults();
            distinctQuery.add(copyDBRow);
        }
        for (Object fieldOfProvidedRow : fieldsOfProvidedRows) {
            DBRow row;
            PropertyWrapper fieldProp = null;
            Iterator<DBRow> i$ = this.allQueryTables.iterator();
            while (i$.hasNext() && (fieldProp = (row = i$.next()).getPropertyWrapperOf(fieldOfProvidedRow)) == null) {
            }
            if (fieldProp == null) {
                throw new IncorrectRowProviderInstanceSuppliedException();
            }
            PropertyWrapperDefinition fieldDefn = fieldProp.getDefinition();
            DBRow fieldRow = null;
            Object thisQDT = null;
            for (DBRow row2 : distinctQuery.allQueryTables) {
                try {
                    thisQDT = fieldDefn.rawJavaValue(row2);
                }
                catch (FailedToSetPropertyValueOnRowDefinition ex) {
                    // empty catch block
                }
                if (thisQDT == null) continue;
                fieldRow = row2;
                break;
            }
            if (thisQDT == null || fieldRow == null) {
                throw new DBRuntimeException("Unable To Find Columns Specified");
            }
            fieldRow.addReturnFields(thisQDT);
            distinctQuery.setBlankQueryAllowed(true);
            DBExpression column = fieldRow.column(fieldDefn.getQueryableDatatype(fieldRow));
            distinctQuery.addToSortOrder(column);
            distinctQuery.addGroupByColumn(fieldRow, column);
            returnList = distinctQuery.getAllRows();
        }
        return returnList;
    }

    private static class QueryGraphVertexFillPaintTransformer
    implements Transformer<QueryGraphNode, Paint> {
        QueryGraphVertexFillPaintTransformer() {
        }

        public Paint transform(QueryGraphNode i) {
            if (i.isRequiredNode()) {
                return Color.RED;
            }
            return Color.ORANGE;
        }
    }

    private class QueryGraphEdgeLabelTransformer
    extends ToStringLabeller<DBExpression> {
        QueryGraphEdgeLabelTransformer() {
        }

        public String transform(DBExpression v) {
            return v.toSQLString(DBQuery.this.database).replaceAll("[^ ]*\\.", "");
        }
    }

    private static class DBRowNameComparator
    implements Comparator<DBRow> {
        DBRowNameComparator() {
        }

        @Override
        public int compare(DBRow first, DBRow second) {
            String firstCanonicalName = first.getClass().getCanonicalName();
            String secondCanonicalName = second.getClass().getCanonicalName();
            if (firstCanonicalName != null && secondCanonicalName != null) {
                return firstCanonicalName.compareTo(secondCanonicalName);
            }
            return first.getClass().getSimpleName().compareTo(second.getClass().getSimpleName());
        }
    }

    private static class DBRowClassNameComparator
    implements Comparator<Class<?>> {
        DBRowClassNameComparator() {
        }

        @Override
        public int compare(Class<?> first, Class<?> second) {
            String firstCanonicalName = first.getCanonicalName();
            String secondCanonicalName = second.getCanonicalName();
            if (firstCanonicalName != null && secondCanonicalName != null) {
                return firstCanonicalName.compareTo(secondCanonicalName);
            }
            return first.getSimpleName().compareTo(second.getSimpleName());
        }
    }

    protected static class QueryState {
        private final DBQuery query;
        private final DBDatabase database;
        private final DBDefinition defn;
        private QueryGraph graph;
        private final List<BooleanExpression> remainingExpressions;
        private final List<BooleanExpression> consumedExpressions = new ArrayList<BooleanExpression>();
        private final List<String> requiredConditions = new ArrayList<String>();
        private final List<String> optionalConditions = new ArrayList<String>();

        QueryState(DBQuery query, DBDatabase database) {
            this.query = query;
            this.database = database;
            this.defn = database.getDefinition();
            this.remainingExpressions = new ArrayList<BooleanExpression>(query.getConditions());
        }

        private Iterable<BooleanExpression> getRemainingExpressions() {
            return new ArrayList<BooleanExpression>(this.remainingExpressions);
        }

        private void consumeExpression(BooleanExpression expr) {
            this.remainingExpressions.remove(expr);
            this.consumedExpressions.add(expr);
        }

        private void setGraph(QueryGraph queryGraph) {
            this.graph = queryGraph;
        }

        protected void addRequiredCondition(String conditionClause) {
            this.requiredConditions.add(conditionClause);
        }

        private void addRequiredConditions(List<String> conditionClauses) {
            this.requiredConditions.addAll(conditionClauses);
        }

        protected List<String> getRequiredConditions() {
            return this.requiredConditions;
        }

        protected void addOptionalConditions(List<String> conditionClauses) {
            this.optionalConditions.addAll(conditionClauses);
        }

        protected List<String> getOptionalConditions() {
            return this.optionalConditions;
        }
    }
}

