/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import nz.co.gregs.dbvolution.DBQuery;
import nz.co.gregs.dbvolution.DBQueryRow;
import nz.co.gregs.dbvolution.DBReport;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.DBScript;
import nz.co.gregs.dbvolution.DBTable;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.DBTransactionStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.exceptions.AccidentalDroppingOfDatabaseException;
import nz.co.gregs.dbvolution.exceptions.AccidentalDroppingOfTableException;
import nz.co.gregs.dbvolution.exceptions.AutoCommitActionDuringTransactionException;
import nz.co.gregs.dbvolution.exceptions.UnexpectedNumberOfRowsException;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.transactions.DBRawSQLTransaction;
import nz.co.gregs.dbvolution.transactions.DBTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DBDatabase
implements Cloneable {
    private static final Log log = LogFactory.getLog(DBDatabase.class);
    private String driverName = "";
    private String jdbcURL = "";
    private String username = "";
    private String password = null;
    private DataSource dataSource = null;
    private boolean printSQLBeforeExecuting;
    private boolean isInATransaction = false;
    private DBTransactionStatement transactionStatement;
    private DBDefinition definition = null;
    private String databaseName;
    private boolean batchIfPossible = true;
    private boolean preventAccidentalDroppingOfTables = true;
    private boolean preventAccidentalDroppingDatabase = true;
    private int connectionsActive = 0;
    private final Object getStatementSynchronizeObject = new Object();
    private final Object getConnectionSynchronizeObject = new Object();
    private Connection transactionConnection;
    private static final transient Map<DBDatabase, List<Connection>> busyConnections = new HashMap<DBDatabase, List<Connection>>();
    private static final transient HashMap<DBDatabase, List<Connection>> freeConnections = new HashMap();

    protected DBDatabase clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        DBDatabase newInstance = (DBDatabase)clone;
        return newInstance;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.driverName != null ? this.driverName.hashCode() : 0);
        hash = 29 * hash + (this.jdbcURL != null ? this.jdbcURL.hashCode() : 0);
        hash = 29 * hash + (this.username != null ? this.username.hashCode() : 0);
        hash = 29 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash = 29 * hash + (this.dataSource != null ? this.dataSource.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBDatabase other = (DBDatabase)obj;
        if (this.driverName == null ? other.driverName != null : !this.driverName.equals(other.driverName)) {
            return false;
        }
        if (this.jdbcURL == null ? other.jdbcURL != null : !this.jdbcURL.equals(other.jdbcURL)) {
            return false;
        }
        if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return this.dataSource == other.dataSource || this.dataSource != null && this.dataSource.equals(other.dataSource);
    }

    protected DBDatabase() {
    }

    public DBDatabase(DBDefinition definition, DataSource ds) {
        this.definition = definition;
        this.dataSource = ds;
    }

    public DBDatabase(DBDefinition definition, String driverName, String jdbcURL, String username, String password) {
        this.definition = definition;
        this.driverName = driverName;
        this.jdbcURL = jdbcURL;
        this.password = password;
        this.username = username;
    }

    private DBTransactionStatement getDBTransactionStatement() throws SQLException {
        DBStatement dbStatement = this.getDBStatement();
        if (dbStatement instanceof DBTransactionStatement) {
            return (DBTransactionStatement)dbStatement;
        }
        return new DBTransactionStatement(this, dbStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement getDBStatement() {
        DBStatement statement;
        Connection connection = null;
        Object object = this.getStatementSynchronizeObject;
        synchronized (object) {
            if (this.isInATransaction) {
                statement = this.transactionStatement;
            } else {
                try {
                    connection = this.getConnection();
                    while (connection.isClosed()) {
                        this.discardConnection(connection);
                        connection = this.getConnection();
                    }
                    statement = new DBStatement(this, connection);
                }
                catch (SQLException cantCreateStatement) {
                    this.discardConnection(connection);
                    throw new RuntimeException("Unable to create a Statement: please check the database URL, username, and password, and that the appropriate libaries have been supplied: URL=" + this.getJdbcURL() + " USERNAME=" + this.getUsername(), cantCreateStatement);
                }
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws RuntimeException {
        if (this.isInATransaction) {
            return this.transactionConnection;
        }
        Connection conn = null;
        while (conn == null) {
            if (this.supportsPooledConnections()) {
                HashMap<DBDatabase, List<Connection>> hashMap = freeConnections;
                synchronized (hashMap) {
                    conn = freeConnections.isEmpty() || this.getConnectionList(freeConnections).isEmpty() ? this.getRawConnection() : this.getConnectionList(freeConnections).get(0);
                }
            } else {
                conn = this.getRawConnection();
            }
            try {
                if (!conn.isClosed()) continue;
                this.discardConnection(conn);
                conn = null;
            }
            catch (SQLException ex) {
                Logger.getLogger(DBDatabase.class.getName()).log(Level.FINEST, null, ex);
            }
        }
        this.usedConnection(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getRawConnection() throws RuntimeException {
        Connection connection;
        Object object = this.getConnectionSynchronizeObject;
        synchronized (object) {
            if (this.dataSource == null) {
                try {
                    Class.forName(this.getDriverName());
                }
                catch (ClassNotFoundException noDriver) {
                    throw new RuntimeException("No Driver Found: please check the driver name is correct and the appropriate libaries have been supplied: DRIVERNAME=" + this.getDriverName(), noDriver);
                }
                try {
                    connection = this.getConnectionFromDriverManager();
                }
                catch (SQLException noConnection) {
                    throw new RuntimeException("Connection Not Established: please check the database URL, username, and password, and that the appropriate libaries have been supplied: URL=" + this.getJdbcURL() + " USERNAME=" + this.getUsername(), noConnection);
                }
            }
            try {
                connection = this.dataSource.getConnection();
            }
            catch (SQLException noConnection) {
                throw new RuntimeException("Connection Not Established using the DataSource: please check the datasource - " + this.dataSource.toString(), noConnection);
            }
            this.connectionOpened(connection);
        }
        return connection;
    }

    public final DBActionList insert(DBRow ... listOfRowsToInsert) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        for (DBRow row : listOfRowsToInsert) {
            changes.addAll(this.getDBTable(row).insert(new DBRow[]{row}));
        }
        return changes;
    }

    public final DBActionList insert(Collection<? extends DBRow> listOfRowsToInsert) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        if (listOfRowsToInsert.size() > 0) {
            for (DBRow dBRow : listOfRowsToInsert) {
                changes.addAll(this.getDBTable(dBRow).insert(new DBRow[]{dBRow}));
            }
        }
        return changes;
    }

    public final DBActionList delete(DBRow ... rows) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        for (DBRow row : rows) {
            changes.addAll(this.getDBTable(row).delete(new DBRow[]{row}));
        }
        return changes;
    }

    public final DBActionList delete(Collection<? extends DBRow> list) throws SQLException {
        DBActionList changes = new DBActionList(new DBAction[0]);
        if (list.size() > 0) {
            for (DBRow dBRow : list) {
                changes.addAll(this.getDBTable(dBRow).delete(new DBRow[]{dBRow}));
            }
        }
        return changes;
    }

    public final DBActionList update(DBRow ... rows) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        for (DBRow row : rows) {
            actions.addAll(this.getDBTable(row).update(row));
        }
        return actions;
    }

    public final DBActionList update(Collection<? extends DBRow> listOfRowsToUpdate) throws SQLException {
        DBActionList actions = new DBActionList(new DBAction[0]);
        if (listOfRowsToUpdate.size() > 0) {
            for (DBRow dBRow : listOfRowsToUpdate) {
                actions.addAll(this.getDBTable(dBRow).update(dBRow));
            }
        }
        return actions;
    }

    public <R extends DBRow> List<R> get(R exampleRow) throws SQLException {
        DBTable<R> dbTable = this.getDBTable(exampleRow);
        return dbTable.getAllRows();
    }

    public <R extends DBRow> List<R> getByExample(R exampleRow) throws SQLException {
        return this.get(exampleRow);
    }

    public <R extends DBRow> List<R> get(Long expectedNumberOfRows, R exampleRow) throws SQLException, UnexpectedNumberOfRowsException {
        if (expectedNumberOfRows == null) {
            return this.get(exampleRow);
        }
        return this.getDBTable(exampleRow).getRowsByExample(exampleRow, expectedNumberOfRows);
    }

    public <R extends DBRow> List<R> getByExample(Long expectedNumberOfRows, R exampleRow) throws SQLException, UnexpectedNumberOfRowsException {
        return this.get(expectedNumberOfRows, exampleRow);
    }

    public List<DBQueryRow> get(DBRow ... rows) throws SQLException {
        DBQuery dbQuery = this.getDBQuery(rows);
        return dbQuery.getAllRows();
    }

    public List<DBQueryRow> getByExamples(DBRow ... rows) throws SQLException {
        return this.get(rows);
    }

    public void print(List<?> rows) {
        if (rows != null) {
            for (Object row : rows) {
                System.out.println(row.toString());
            }
        }
    }

    public List<DBQueryRow> get(Long expectedNumberOfRows, DBRow ... rows) throws SQLException, UnexpectedNumberOfRowsException {
        if (expectedNumberOfRows == null) {
            return this.get(rows);
        }
        return this.getDBQuery(rows).getAllRows(expectedNumberOfRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V doTransaction(DBTransaction<V> dbTransaction, Boolean commit) throws SQLException, Exception {
        DBDatabase db;
        DBDatabase dBDatabase = this;
        synchronized (dBDatabase) {
            db = this.clone();
        }
        V returnValues = null;
        db.transactionStatement = db.getDBTransactionStatement();
        try {
            db.isInATransaction = true;
            db.transactionConnection = db.transactionStatement.getConnection();
            boolean wasAutoCommit = db.transactionConnection.getAutoCommit();
            db.transactionConnection.setAutoCommit(false);
            try {
                returnValues = dbTransaction.doTransaction(db);
                if (commit.booleanValue()) {
                    db.transactionConnection.commit();
                    log.info((Object)"Transaction Successful: Commit Performed");
                } else {
                    db.transactionConnection.rollback();
                    log.info((Object)"Transaction Successful: ROLLBACK Performed");
                }
            }
            catch (Exception ex) {
                db.transactionConnection.rollback();
                log.warn((Object)("Exception Occurred: ROLLBACK Performed! " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            finally {
                db.transactionConnection.setAutoCommit(wasAutoCommit);
                this.discardConnection(db.transactionConnection);
            }
        }
        finally {
            db.transactionStatement.transactionFinished();
            db.isInATransaction = false;
            db.transactionConnection = null;
            db.transactionStatement = null;
        }
        return returnValues;
    }

    public <V> V doTransaction(DBTransaction<V> dbTransaction) throws SQLException, Exception {
        return this.doTransaction(dbTransaction, true);
    }

    public <V> V doReadOnlyTransaction(DBTransaction<V> dbTransaction) throws SQLException, Exception {
        return this.doTransaction(dbTransaction, false);
    }

    public DBActionList implement(DBScript script) throws Exception {
        return script.implement(this);
    }

    public DBActionList test(DBScript script) throws Exception {
        return script.test(this);
    }

    public String getDriverName() {
        return this.driverName;
    }

    protected void setDriverName(String driver) {
        this.driverName = driver;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public <R extends DBRow> DBTable<R> getDBTable(R example) {
        return DBTable.getInstance(this, example);
    }

    public DBQuery getDBQuery(DBRow ... examples) {
        return DBQuery.getInstance(this, examples);
    }

    public void setPrintSQLBeforeExecuting(boolean b) {
        this.printSQLBeforeExecuting = b;
    }

    public boolean isPrintSQLBeforeExecuting() {
        return this.printSQLBeforeExecuting;
    }

    public void printSQLIfRequested(String sqlString) {
        this.printSQLIfRequested(sqlString, System.out);
    }

    void printSQLIfRequested(String sqlString, PrintStream out) {
        if (this.printSQLBeforeExecuting) {
            out.println(sqlString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(DBRow newTableRow) throws SQLException, AutoCommitActionDuringTransactionException {
        this.preventDDLDuringTransaction("DBDatabase.createTable()");
        StringBuilder sqlScript = new StringBuilder();
        ArrayList<PropertyWrapper> pkFields = new ArrayList<PropertyWrapper>();
        String lineSeparator = System.getProperty("line.separator");
        sqlScript.append(this.definition.getCreateTableStart()).append(this.definition.formatTableName(newTableRow)).append(this.definition.getCreateTableColumnsStart()).append(lineSeparator);
        String sep = "";
        String nextSep = this.definition.getCreateTableColumnsSeparator();
        List<PropertyWrapper> fields = newTableRow.getPropertyWrappers();
        for (PropertyWrapper field : fields) {
            if (!field.isColumn()) continue;
            String colName = field.columnName();
            sqlScript.append(sep).append(this.definition.formatColumnName(colName)).append(this.definition.getCreateTableColumnsNameAndTypeSeparator()).append(this.definition.getSQLTypeAndModifiersOfDBDatatype(field));
            sep = nextSep + lineSeparator;
            if (!field.isPrimaryKey()) continue;
            pkFields.add(field);
        }
        if (this.definition.prefersTrailingPrimaryKeyDefinition()) {
            String pkStart = lineSeparator + this.definition.getCreateTablePrimaryKeyClauseStart();
            String pkMiddle = this.definition.getCreateTablePrimaryKeyClauseMiddle();
            String pkEnd = this.definition.getCreateTablePrimaryKeyClauseEnd() + lineSeparator;
            String pkSep = pkStart;
            for (PropertyWrapper field : pkFields) {
                sqlScript.append(pkSep).append(this.definition.formatColumnName(field.columnName()));
                pkSep = pkMiddle;
            }
            if (!pkSep.equalsIgnoreCase(pkStart)) {
                sqlScript.append(pkEnd);
            }
        }
        sqlScript.append(this.definition.getCreateTableColumnsEnd()).append(lineSeparator).append(this.definition.endSQLStatement());
        String sqlString = sqlScript.toString();
        DBStatement dbStatement = this.getDBStatement();
        try {
            dbStatement.execute(sqlString);
            if (this.definition.usesTriggerBasedIdentities() && pkFields.size() == 1) {
                List<String> triggerBasedIdentitySQL = this.definition.getTriggerBasedIdentitySQL(this, this.definition.formatTableName(newTableRow), this.definition.formatColumnName(((PropertyWrapper)pkFields.get(0)).columnName()));
                for (String sql : triggerBasedIdentitySQL) {
                    dbStatement.execute(sql);
                }
            }
        }
        finally {
            dbStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(DBRow tableRow) throws SQLException, AutoCommitActionDuringTransactionException, AccidentalDroppingOfTableException {
        this.preventDDLDuringTransaction("DBDatabase.dropTable()");
        if (this.preventAccidentalDroppingOfTables) {
            throw new AccidentalDroppingOfTableException();
        }
        StringBuilder sqlScript = new StringBuilder();
        String dropTableStart = this.definition.getDropTableStart();
        String formatTableName = this.definition.formatTableName(tableRow);
        Object endSQLStatement = this.definition.endSQLStatement();
        sqlScript.append(dropTableStart).append(formatTableName).append(endSQLStatement);
        String sqlString = sqlScript.toString();
        DBStatement dbStatement = this.getDBStatement();
        try {
            dbStatement.execute(sqlString);
        }
        finally {
            dbStatement.close();
        }
    }

    public <TR extends DBRow> void dropTableNoExceptions(TR tableRow) throws AccidentalDroppingOfTableException, AutoCommitActionDuringTransactionException {
        try {
            this.dropTable(tableRow);
            this.dropAnyAssociatedDatabaseObjects(tableRow);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public DBDefinition getDefinition() {
        return this.definition;
    }

    protected void setDefinition(DBDefinition defn) {
        if (this.definition == null) {
            this.definition = defn;
        }
    }

    public boolean willCreateBlankQuery(DBRow row) {
        return row.willCreateBlankQuery(this);
    }

    public void dropDatabase() throws Exception, UnsupportedOperationException, AutoCommitActionDuringTransactionException {
        this.preventDDLDuringTransaction("DBDatabase.dropDatabase()");
        if (this.preventAccidentalDroppingOfTables) {
            throw new AccidentalDroppingOfTableException();
        }
        if (this.preventAccidentalDroppingDatabase) {
            throw new AccidentalDroppingOfDatabaseException();
        }
        String dropStr = this.getDefinition().getDropDatabase(this.getDatabaseName());
        this.printSQLIfRequested(dropStr);
        log.info((Object)dropStr);
        this.doTransaction(new DBRawSQLTransaction(dropStr));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    protected void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean batchSQLStatementsWhenPossible() {
        return this.batchIfPossible;
    }

    public void setBatchSQLStatementsWhenPossible(boolean batchSQLStatementsWhenPossible) {
        this.batchIfPossible = batchSQLStatementsWhenPossible;
    }

    private void preventDDLDuringTransaction(String message) throws AutoCommitActionDuringTransactionException {
        if (this.isInATransaction) {
            throw new AutoCommitActionDuringTransactionException(message);
        }
    }

    public void preventDroppingOfTables(boolean droppingTablesIsAMistake) {
        this.preventAccidentalDroppingOfTables = droppingTablesIsAMistake;
    }

    public void preventDroppingOfDatabases(boolean justLeaveThisAtTrue) {
        this.preventAccidentalDroppingDatabase = justLeaveThisAtTrue;
    }

    public boolean supportsFullOuterJoin() {
        return this.supportsFullOuterJoinNatively();
    }

    protected boolean supportsFullOuterJoinNatively() {
        return true;
    }

    public <A extends DBReport> List<A> get(A report, DBRow ... examples) throws SQLException {
        return DBReport.getRows(this, report, examples);
    }

    public <A extends DBReport> List<A> getRows(A report, DBRow ... examples) throws SQLException {
        return DBReport.getRows(this, report, examples);
    }

    boolean supportsPaging(QueryOptions options) {
        return this.definition.supportsPaging(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionOpened(Connection connection) {
        Object object = this.getConnectionSynchronizeObject;
        synchronized (object) {
            ++this.connectionsActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        Object object = this.getConnectionSynchronizeObject;
        synchronized (object) {
            --this.connectionsActive;
        }
    }

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return DriverManager.getConnection(this.getJdbcURL(), this.getUsername(), this.getPassword());
    }

    protected void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected <TR extends DBRow> void dropAnyAssociatedDatabaseObjects(TR tableRow) throws SQLException {
    }

    public synchronized void unusedConnection(Connection connection) throws SQLException {
        if (this.supportsPooledConnections()) {
            this.getConnectionList(busyConnections).remove(connection);
            this.getConnectionList(freeConnections).add(connection);
        } else {
            this.discardConnection(connection);
        }
    }

    protected boolean supportsPooledConnections() {
        return true;
    }

    private synchronized void usedConnection(Connection connection) {
        if (this.supportsPooledConnections()) {
            this.getConnectionList(freeConnections).remove(connection);
            this.getConnectionList(busyConnections).add(connection);
        }
    }

    private synchronized void discardConnection(Connection connection) {
        this.getConnectionList(busyConnections).remove(connection);
        this.getConnectionList(freeConnections).remove(connection);
        try {
            connection.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBDatabase.class.getName()).log(Level.FINEST, null, ex);
        }
        this.connectionClosed(connection);
    }

    private synchronized List<Connection> getConnectionList(Map<DBDatabase, List<Connection>> connectionMap) {
        List<Connection> connList = connectionMap.get(this);
        if (connList == null) {
            connList = new ArrayList<Connection>();
            connectionMap.put(this, connList);
        }
        return connList;
    }
}

