/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PrimitiveMappers {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_OBJECT_MAPPER = PrimitiveMappers.createPrimitiveObjectMapper();
    public static final Map<Class<?>, Object> DEFAULT_VALUE_MAPPER = PrimitiveMappers.createDefaultValueMapper(false);
    public static final Map<Class<?>, Object> DEFAULT_WRAPPED_VALUE_MAPPER = PrimitiveMappers.createDefaultValueMapper(true);
    public static final Collection<Object> ZEROS = DEFAULT_WRAPPED_VALUE_MAPPER.values();

    private PrimitiveMappers() {
    }

    private static Map<Class<?>, Class<?>> createPrimitiveObjectMapper() {
        HashMap<Class<Comparable<Boolean>>, Class> result = new HashMap<Class<Comparable<Boolean>>, Class>();
        result.put(Boolean.TYPE, Boolean.class);
        result.put(Byte.TYPE, Byte.class);
        result.put(Character.TYPE, Character.class);
        result.put(Double.TYPE, Double.class);
        result.put(Float.TYPE, Float.class);
        result.put(Integer.TYPE, Integer.class);
        result.put(Long.TYPE, Long.class);
        result.put(Short.TYPE, Short.class);
        return Collections.unmodifiableMap(result);
    }

    private static Map<Class<?>, Object> createDefaultValueMapper(boolean includeWrapped) {
        HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> result = new HashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        result.put(Boolean.TYPE, Boolean.valueOf(false));
        result.put(Byte.TYPE, Byte.valueOf((byte)0));
        result.put(Character.TYPE, Character.valueOf('\u0000'));
        result.put(Double.TYPE, Double.valueOf(0.0));
        result.put(Float.TYPE, Float.valueOf(0.0f));
        result.put(Integer.TYPE, Integer.valueOf(0));
        result.put(Long.TYPE, Long.valueOf(0L));
        result.put(Short.TYPE, Short.valueOf((short)0));
        if (includeWrapped) {
            result.put(Boolean.class, Boolean.valueOf(false));
            result.put(Byte.class, Byte.valueOf((byte)0));
            result.put(Character.class, Character.valueOf('\u0000'));
            result.put(Double.class, Double.valueOf(0.0));
            result.put(Float.class, Float.valueOf(0.0f));
            result.put(Integer.class, Integer.valueOf(0));
            result.put(Long.class, Long.valueOf(0L));
            result.put(Short.class, Short.valueOf((short)0));
        }
        return Collections.unmodifiableMap(result);
    }
}

