/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.testhelpers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import nl.jqno.equalsverifier.internal.exceptions.MessagingException;

@SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"}, justification="Only called in test code, not production.")
public final class ExpectedException {
    private final Throwable e;

    private ExpectedException(Throwable e) {
        this.e = e;
    }

    public static ExpectedException when(Runnable runnable) {
        try {
            runnable.run();
            return new ExpectedException(null);
        }
        catch (Throwable e) {
            return new ExpectedException(e);
        }
    }

    public ExpectedException assertThrows(Class<? extends Throwable> expectedException) {
        if (this.e == null) {
            this.fail("Expected " + expectedException.getSimpleName() + " but none was thrown.");
        }
        if (!expectedException.isInstance(this.e)) {
            this.fail("Expected " + expectedException.getCanonicalName() + " but was " + this.e.getClass().getCanonicalName() + ".");
        }
        return this;
    }

    public ExpectedException assertFailure() {
        return this.assertThrows(AssertionError.class);
    }

    public ExpectedException assertCause(Class<? extends Throwable> expectedCause) {
        for (Throwable cause = this.e.getCause(); cause != null; cause = cause.getCause()) {
            if (!cause.getClass().equals(expectedCause)) continue;
            return this;
        }
        this.fail("Expected " + expectedCause.getSimpleName() + " to be in the cause but it wasn't.");
        return this;
    }

    public ExpectedException assertNotCause(Class<? extends Throwable> expectedCause) {
        for (Throwable cause = this.e.getCause(); cause != null; cause = cause.getCause()) {
            if (!cause.getClass().equals(expectedCause)) continue;
            this.fail("Expected " + expectedCause.getSimpleName() + " not to be in the cause but it was.");
        }
        return this;
    }

    public ExpectedException assertCauseMessageContains(String fragment) {
        for (Throwable cause = this.e.getCause(); cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null || !cause.getMessage().contains(fragment)) continue;
            return this;
        }
        this.fail("Expected cause to contain " + fragment + " but it doesn't.");
        return this;
    }

    public ExpectedException assertCauseMessageDoesNotContain(String fragment) {
        for (Throwable cause = this.e.getCause(); cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null || !cause.getMessage().contains(fragment)) continue;
            this.fail("Expected cause not to contain " + fragment + " but it does.");
        }
        return this;
    }

    public ExpectedException assertMessageContains(String ... fragments) {
        String message = this.e.getMessage();
        for (String fragment : fragments) {
            if (message.contains(fragment)) continue;
            this.fail("Message [" + message + "] does not contain [" + fragment + "]");
        }
        return this;
    }

    public ExpectedException assertMessageContainsOnce(String fragment) {
        int occurrences = 0;
        String message = this.e.getMessage();
        while (message.indexOf(fragment) > -1) {
            ++occurrences;
            message = message.substring(message.indexOf(fragment) + fragment.length());
        }
        if (occurrences != 1) {
            this.fail("Message [" + this.e.getMessage() + "] contains [" + fragment + "] " + occurrences + " times; should be 1.");
        }
        return this;
    }

    public ExpectedException assertMessageDoesNotContain(String ... fragments) {
        String message = this.e.getMessage();
        for (String fragment : fragments) {
            if (!message.contains(fragment)) continue;
            this.fail("Message [" + message + "] contains [" + fragment + "]");
        }
        return this;
    }

    public ExpectedException assertMessageDoesNotContainAfterRemove(String toRemove, String ... fragments) {
        String message = this.e.getMessage().replaceAll(toRemove, "");
        for (String fragment : fragments) {
            if (!message.contains(fragment)) continue;
            this.fail("Message [" + message + "] contains [" + fragment + "]");
        }
        return this;
    }

    public ExpectedException assertDescriptionContains(String ... fragments) {
        if (!(this.e instanceof MessagingException)) {
            this.fail("Exception " + this.e.getClass().getSimpleName() + " is not a MessagingException.");
        }
        MessagingException me = (MessagingException)this.e;
        String description = me.getDescription();
        for (String fragment : fragments) {
            if (description.contains(fragment)) continue;
            this.fail("Description [" + description + "] does not contain [" + fragment + "]");
        }
        return this;
    }

    public ExpectedException assertDescriptionDoesNotContain(String ... fragments) {
        if (!(this.e instanceof MessagingException)) {
            this.fail("Exception " + this.e.getClass().getSimpleName() + " is not a MessagingException.");
        }
        MessagingException me = (MessagingException)this.e;
        String description = me.getDescription();
        for (String fragment : fragments) {
            if (!description.contains(fragment)) continue;
            this.fail("Description [" + description + "] contains [" + fragment + "]");
        }
        return this;
    }

    private void fail(String msg) {
        throw new AssertionError((Object)msg);
    }
}

