/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.annotations;

import java.util.HashMap;
import java.util.Map;
import nl.jqno.equalsverifier.internal.reflection.annotations.Annotation;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationClassCache;

public class AnnotationCache {
    private final Map<Class<?>, AnnotationClassCache> cache = new HashMap();

    public boolean hasResolved(Class<?> type) {
        return this.cache.containsKey(type);
    }

    public boolean hasClassAnnotation(Class<?> type, Annotation annotation) {
        return this.hasResolved(type) && this.cache.get(type).hasClassAnnotation(annotation);
    }

    public boolean hasFieldAnnotation(Class<?> type, String fieldName, Annotation annotation) {
        return this.hasResolved(type) && this.cache.get(type).hasFieldAnnotation(fieldName, annotation);
    }

    public void addClassAnnotation(Class<?> type, Annotation annotation) {
        this.ensureEntry(type);
        this.cache.get(type).addClassAnnotation(annotation);
    }

    public void addField(Class<?> type, String fieldName) {
        this.ensureEntry(type);
        this.cache.get(type).addField(fieldName);
    }

    public void addFieldAnnotation(Class<?> type, String fieldName, Annotation annotation) {
        this.ensureEntry(type);
        this.cache.get(type).addFieldAnnotation(fieldName, annotation);
    }

    private void ensureEntry(Class<?> type) {
        if (!this.hasResolved(type)) {
            this.cache.put(type, new AnnotationClassCache());
        }
    }
}

