/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.PrimitiveMappers;
import nl.jqno.equalsverifier.internal.util.Rethrow;

final class RecordObjectAccessor<T>
extends ObjectAccessor<T> {
    private final Constructor<T> constructor = this.getRecordConstructor();

    RecordObjectAccessor(T object, Class<T> type) {
        super(object, type);
    }

    @Override
    public T copy() {
        List params = this.fields().map(this::getField).collect(Collectors.toList());
        return this.callRecordConstructor(params);
    }

    @Override
    public <S extends T> S copyIntoSubclass(Class<S> subclass) {
        throw new EqualsVerifierInternalBugException("Can't copy a record into a subclass of itself.");
    }

    @Override
    public T copyIntoAnonymousSubclass() {
        throw new EqualsVerifierInternalBugException("Can't copy a record into an anonymous subclass of itself.");
    }

    @Override
    public ObjectAccessor<T> scramble(PrefabValues prefabValues, TypeTag enclosingType) {
        return this.makeAccessor(f -> {
            Object value = this.getField((Field)f);
            TypeTag tag = TypeTag.of(f, enclosingType);
            return prefabValues.giveOther(tag, value);
        });
    }

    @Override
    public ObjectAccessor<T> shallowScramble(PrefabValues prefabValues, TypeTag enclosingType) {
        throw new EqualsVerifierInternalBugException("Record: can't shallow-scramble a record.");
    }

    @Override
    public ObjectAccessor<T> clear(Predicate<Field> canBeDefault, PrefabValues prefabValues, TypeTag enclosingType) {
        return this.makeAccessor(f -> canBeDefault.test((Field)f) ? PrimitiveMappers.DEFAULT_VALUE_MAPPER.get(f.getType()) : prefabValues.giveRed(TypeTag.of(f, enclosingType)));
    }

    @Override
    public ObjectAccessor<T> withDefaultedField(Field field) {
        return this.modify(field, PrimitiveMappers.DEFAULT_VALUE_MAPPER.get(field.getType()));
    }

    @Override
    public ObjectAccessor<T> withChangedField(Field field, PrefabValues prefabValues, TypeTag enclosingType) {
        TypeTag tag = TypeTag.of(field, enclosingType);
        Object currentValue = this.getField(field);
        Object newValue = prefabValues.giveOther(tag, currentValue);
        return this.modify(field, newValue);
    }

    @Override
    public ObjectAccessor<T> withFieldSetTo(Field field, Object newValue) {
        return this.modify(field, newValue);
    }

    private ObjectAccessor<T> modify(Field field, Object value) {
        return this.makeAccessor(f -> f.equals(field) ? value : this.getField((Field)f));
    }

    private ObjectAccessor<T> makeAccessor(Function<Field, Object> determineValue) {
        List params = this.fields().map(determineValue).collect(Collectors.toList());
        T newObject = this.callRecordConstructor(params);
        return ObjectAccessor.of(newObject);
    }

    private Stream<Field> fields() {
        return StreamSupport.stream(FieldIterable.ofIgnoringStatic(this.type()).spliterator(), false);
    }

    private Constructor<T> getRecordConstructor() {
        return Rethrow.rethrow(() -> {
            List<Class> constructorTypes = this.fields().map(Field::getType).collect(Collectors.toList());
            Constructor result = this.type().getDeclaredConstructor(constructorTypes.toArray(new Class[0]));
            result.setAccessible(true);
            return result;
        });
    }

    private T callRecordConstructor(List<?> params) {
        return (T)Rethrow.rethrow(() -> this.constructor.newInstance(params.toArray(new Object[0])), e -> this.buildMessage((Throwable)e, this.constructor.getDeclaringClass(), params));
    }

    private String buildMessage(Throwable e, Class<?> type, List<?> params) {
        String prefix = "Record: failed to run constructor for record type " + type.getName() + "\n  These were the values passed to the constructor: " + params;
        if (e.getCause() instanceof NullPointerException) {
            return prefix + "\n  If the record does not accept null values for its constructor parameters, consider suppressing Warning.NULL_FIELDS.";
        }
        boolean hasZeros = false;
        boolean hasSomethingElse = false;
        for (Object p : params) {
            if (PrimitiveMappers.ZEROS.contains(p)) {
                hasZeros = true;
                continue;
            }
            hasSomethingElse = true;
        }
        String msg = prefix;
        if (hasZeros) {
            msg = msg + "\n  If the record does not accept 0 or false as a value for its constructor parameters, consider suppressing Warning.ZERO_FIELDS.";
        }
        if (hasSomethingElse) {
            msg = msg + "\n  If the record does not accept any of the given values for its constructor parameters, consider providing prefab values for the types of those fields.";
        }
        return msg;
    }
}

