/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.InPlaceObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.RecordObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.RecordsHelper;

public abstract class ObjectAccessor<T> {
    private final T object;
    private final Class<T> type;

    ObjectAccessor(T object, Class<T> type) {
        this.object = object;
        this.type = type;
    }

    public static <T> ObjectAccessor<T> of(T object) {
        Class<?> type = object.getClass();
        return ObjectAccessor.of(object, type);
    }

    public static <T> ObjectAccessor<T> of(T object, Class<T> type) {
        if (RecordsHelper.isRecord(type)) {
            return new RecordObjectAccessor<T>(object, type);
        }
        return new InPlaceObjectAccessor<T>(object, type);
    }

    public T get() {
        return this.object;
    }

    public Class<T> type() {
        return this.type;
    }

    public T getField(Field field) {
        return (T)FieldAccessor.of(field).get(this.object);
    }

    public abstract T copy();

    public abstract <S extends T> S copyIntoSubclass(Class<S> var1);

    public abstract T copyIntoAnonymousSubclass();

    public abstract ObjectAccessor<T> scramble(PrefabValues var1, TypeTag var2);

    public abstract ObjectAccessor<T> shallowScramble(PrefabValues var1, TypeTag var2);

    public abstract ObjectAccessor<T> clear(Predicate<Field> var1, PrefabValues var2, TypeTag var3);

    public abstract ObjectAccessor<T> withDefaultedField(Field var1);

    public abstract ObjectAccessor<T> withChangedField(Field var1, PrefabValues var2, TypeTag var3);

    public abstract ObjectAccessor<T> withFieldSetTo(Field var1, Object var2);
}

