/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.ByteBuddy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.DynamicType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.TypeValidation;
import nl.jqno.equalsverifier.internal.reflection.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.reflection.SealedTypesHelper;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.util.ObjenesisWrapper;

public final class Instantiator<T> {
    private static final List<String> FORBIDDEN_PACKAGES = Arrays.asList("java.", "javax.", "sun.", "com.sun.", "org.w3c.dom.");
    private static final String FALLBACK_PACKAGE_NAME = Instantiator.getPackageName(Instantiator.class);
    private final Class<T> type;

    private Instantiator(Class<T> type) {
        this.type = type;
    }

    public static <T> Instantiator<T> of(Class<T> type) {
        if (SealedTypesHelper.isSealed(type)) {
            Class concrete = SealedTypesHelper.findInstantiableSubclass(type).get();
            return Instantiator.of(concrete);
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return new Instantiator<T>(Instantiator.giveDynamicSubclass(type, "", b -> b));
        }
        return new Instantiator<T>(type);
    }

    public T instantiate() {
        return ObjenesisWrapper.getObjenesis().newInstance(this.type);
    }

    public T instantiateAnonymousSubclass() {
        Class<T> proxyClass = Instantiator.giveDynamicSubclass(this.type, "", b -> b);
        return ObjenesisWrapper.getObjenesis().newInstance(proxyClass);
    }

    public static synchronized <S> Class<S> giveDynamicSubclass(Class<S> superclass, String nameSuffix, UnaryOperator<DynamicType.Builder<S>> modify) {
        boolean isSystemClass = Instantiator.isSystemClass(superclass.getName());
        String namePrefix = isSystemClass ? FALLBACK_PACKAGE_NAME : Instantiator.getPackageName(superclass);
        String name = namePrefix + (namePrefix.isEmpty() ? "" : ".") + superclass.getSimpleName() + "$$DynamicSubclass$" + Integer.toHexString(superclass.hashCode()) + "$" + nameSuffix;
        Class context = isSystemClass ? Instantiator.class : superclass;
        ClassLoader classLoader = context.getClassLoader();
        Class existsAlready = Util.classForName(classLoader, name);
        if (existsAlready != null) {
            return existsAlready;
        }
        ClassLoadingStrategy<ClassLoader> cs = Instantiator.getClassLoadingStrategy(context);
        DynamicType.Builder builder = new ByteBuddy().with(TypeValidation.DISABLED).subclass(superclass).name(name);
        builder = (DynamicType.Builder)modify.apply(builder);
        return builder.make().load(classLoader, cs).getLoaded();
    }

    private static String getPackageName(Class<?> type) {
        String cn = type.getName();
        int dot = cn.lastIndexOf(46);
        return dot != -1 ? cn.substring(0, dot).intern() : "";
    }

    private static <S> ClassLoadingStrategy<ClassLoader> getClassLoadingStrategy(Class<S> context) {
        if (System.getProperty("java.version").startsWith("1.")) {
            return ClassLoadingStrategy.Default.INJECTION.with(context.getProtectionDomain());
        }
        ConditionalInstantiator ci = new ConditionalInstantiator("java.lang.invoke.MethodHandles$Lookup");
        Object lookup = ci.callFactory("java.lang.invoke.MethodHandles", "privateLookupIn", Util.classes(Class.class, MethodHandles.Lookup.class), Util.objects(context, MethodHandles.lookup()));
        return ClassLoadingStrategy.UsingLookup.of(lookup);
    }

    private static boolean isSystemClass(String className) {
        for (String prefix : FORBIDDEN_PACKAGES) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

