/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.CopyFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.MapFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.SimpleFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.SimpleGenericFactory;

public final class Factories {
    private Factories() {
    }

    public static <T> PrefabValueFactory<T> values(T red, T blue, T redCopy) {
        return new SimpleFactory<T>(red, blue, redCopy);
    }

    public static <A, T> PrefabValueFactory<T> simple(Func.Func1<A, T> factory, Supplier<T> emptyFactory) {
        return new SimpleGenericFactory<T>(factory, emptyFactory);
    }

    public static <A, B, T> PrefabValueFactory<T> simple(Func.Func2<A, B, T> factory, Supplier<T> emptyFactory) {
        return new SimpleGenericFactory<T>(factory, emptyFactory);
    }

    public static <A, T extends Collection<A>> PrefabValueFactory<T> collection(Supplier<T> emptyFactory) {
        Func.Func1<Object, Collection> f = a -> {
            Collection coll = (Collection)emptyFactory.get();
            coll.add(a);
            return coll;
        };
        return Factories.simple(f, emptyFactory);
    }

    public static <T, S> PrefabValueFactory<T> copy(Class<S> source, Function<S, T> copy) {
        return new CopyFactory<T, S>(source, copy);
    }

    public static <K, V, T extends Map<K, V>> PrefabValueFactory<T> map(Supplier<T> emptyFactory) {
        return new MapFactory<T>(emptyFactory);
    }
}

