/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.logging;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.DefaultQueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.LoggingCondition;
import net.ttddyy.dsproxy.listener.logging.LoggingFilter;
import net.ttddyy.dsproxy.listener.logging.QueryLogEntryCreator;

public abstract class AbstractQueryLoggingListener
implements QueryExecutionListener {
    protected QueryLogEntryCreator queryLogEntryCreator = new DefaultQueryLogEntryCreator();
    protected boolean writeDataSourceName = true;
    protected boolean writeConnectionId = true;
    protected boolean writeIsolation;
    protected LoggingCondition loggingCondition;
    protected LoggingFilter loggingFilter = LoggingFilter.ALLOW_ALL;

    @Override
    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    @Override
    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        if (this.loggingCondition.getAsBoolean() && this.loggingFilter.shouldLog(execInfo, queryInfoList)) {
            String entry = this.getEntry(execInfo, queryInfoList);
            this.writeLog(entry);
        }
    }

    protected String getEntry(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        return this.queryLogEntryCreator.getLogEntry(execInfo, queryInfoList, this.writeDataSourceName, this.writeConnectionId, this.writeIsolation);
    }

    protected abstract void writeLog(String var1);

    @Deprecated
    public void setLoggerName(String loggerName) {
        this.resetLogger(loggerName);
    }

    @Deprecated
    protected void resetLogger(String loggerName) {
    }

    public void setQueryLogEntryCreator(QueryLogEntryCreator queryLogEntryCreator) {
        this.queryLogEntryCreator = queryLogEntryCreator;
    }

    public QueryLogEntryCreator getQueryLogEntryCreator() {
        return this.queryLogEntryCreator;
    }

    public void setWriteDataSourceName(boolean writeDataSourceName) {
        this.writeDataSourceName = writeDataSourceName;
    }

    public void setWriteConnectionId(boolean writeConnectionId) {
        this.writeConnectionId = writeConnectionId;
    }

    public void setWriteIsolation(boolean writeIsolation) {
        this.writeIsolation = writeIsolation;
    }

    public void setLoggingCondition(LoggingCondition loggingCondition) {
        this.loggingCondition = loggingCondition;
    }

    public void setLoggingFilter(LoggingFilter loggingFilter) {
        this.loggingFilter = loggingFilter;
    }

    public LoggingFilter getLoggingFilter() {
        return this.loggingFilter;
    }
}

