/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

class ComputeClassWriter
extends ClassWriter {
    private final ResourceLoader l;

    public ComputeClassWriter(int flags, ResourceLoader l) {
        super(flags);
        this.l = l;
    }

    protected Type getCommonSuperType(Type type1, Type type2) {
        return Type.getObjectType((String)this.getCommonSuperClass(type1.getInternalName(), type2.getInternalName()));
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            String result;
            block8: {
                ClassReader info1 = this.typeInfo(type1);
                ClassReader info2 = this.typeInfo(type2);
                if ((info1.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type2, info2, type1)) {
                        return type1;
                    }
                    if ((info2.getAccess() & 0x200) != 0 && this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                if ((info2.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block8;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader info, String itf) throws IOException {
        while (!"java/lang/Object".equals(type)) {
            int i;
            String[] itfs = info.getInterfaces();
            for (i = 0; i < itfs.length; ++i) {
                if (!itfs[i].equals(itf)) continue;
                return true;
            }
            for (i = 0; i < itfs.length; ++i) {
                if (!this.typeImplements(itfs[i], this.typeInfo(itfs[i]), itf)) continue;
                return true;
            }
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader typeInfo(String type) throws IOException {
        try (InputStream is = this.l.getResourceAsStream(type + ".class");){
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
    }
}

