/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.util.Properties;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.lang.scala.ScalaLanguageHandler;
import org.apache.commons.lang3.StringUtils;
import scala.collection.Iterator;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.tokenizers.ScalametaTokenizer;
import scala.meta.tokenizers.TokenizeException;
import scala.meta.tokens.Token;

public class ScalaTokenizer
implements Tokenizer {
    public static final String SCALA_VERSION_PROPERTY = "net.sourceforge.pmd.scala.version";
    private final Dialect dialect;

    public ScalaTokenizer() {
        this(System.getProperties());
    }

    public ScalaTokenizer(Properties properties) {
        String scalaVersion = properties.getProperty(SCALA_VERSION_PROPERTY);
        LanguageVersion langVer = scalaVersion == null ? LanguageRegistry.getLanguage((String)"Scala").getDefaultVersion() : LanguageRegistry.getLanguage((String)"Scala").getVersion(scalaVersion);
        this.dialect = ((ScalaLanguageHandler)langVer.getLanguageVersionHandler()).getDialect();
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) throws IOException {
        String filename = sourceCode.getFileName();
        String fullCode = StringUtils.join((Iterable)sourceCode.getCode(), (String)"\n");
        Input.VirtualFile vf = new Input.VirtualFile(filename, fullCode);
        ScalametaTokenizer tokenizer = new ScalametaTokenizer((Input)vf, this.dialect);
        try {
            Token token;
            scala.meta.tokens.Tokens tokens = tokenizer.tokenize();
            ScalaTokenFilter filter = new ScalaTokenFilter((Iterator<Token>)tokens.iterator());
            while ((token = filter.getNextToken()) != null) {
                if (StringUtils.isEmpty((CharSequence)token.text())) continue;
                Position pos = token.pos();
                TokenEntry cpdToken = new TokenEntry(token.text(), filename, pos.startLine() + 1, pos.startColumn() + 1, pos.endColumn() + 1);
                tokenEntries.add(cpdToken);
            }
        }
        catch (Exception e) {
            if (e instanceof TokenizeException) {
                TokenizeException tokE = (TokenizeException)e;
                Position pos = tokE.pos();
                throw new TokenMgrError(pos.startLine() + 1, pos.startColumn() + 1, filename, "Scalameta threw", (Throwable)tokE);
            }
            throw e;
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }

    private static class ScalaTokenFilter {
        Iterator<Token> tokenIter;
        Class<?>[] skippableTokens = new Class[]{Token.Space.class, Token.Tab.class, Token.CR.class, Token.LF.class, Token.FF.class, Token.LFLF.class, Token.EOF.class};

        ScalaTokenFilter(Iterator<Token> iterator) {
            this.tokenIter = iterator;
        }

        Token getNextToken() {
            Token token;
            if (!this.tokenIter.hasNext()) {
                return null;
            }
            while ((token = (Token)this.tokenIter.next()) != null && this.skipToken(token) && this.tokenIter.hasNext()) {
            }
            return token;
        }

        private boolean skipToken(Token token) {
            boolean skip = false;
            if (token.text() != null) {
                for (Class<?> skipTokenClazz : this.skippableTokens) {
                    skip |= skipTokenClazz.isInstance(token);
                }
            }
            return skip;
        }
    }
}

