/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaType;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

@InternalApi
public class ResolutionContext {
    private final ResolutionState state;
    private final List<ResolvableEntity> bestCandidates = new ArrayList<ResolvableEntity>();
    private final List<ResolvableEntity> hiddenCandidates = new ArrayList<ResolvableEntity>();
    private boolean ttlExceeded = false;
    private boolean isCollectingHidden = false;

    ResolutionContext(ResolutionState ctx) {
        this.state = ctx;
    }

    public ResolutionState getState() {
        return this.state;
    }

    public void watchdogTick() throws Watchdog.CountdownException {
        this.state.tick();
    }

    public void addCandidate(ResolvableEntity candidate) {
        if (this.isCollectingHidden) {
            this.hiddenCandidates.add(candidate);
        } else {
            this.bestCandidates.add(candidate);
        }
    }

    void markTtlExceeded() {
        this.ttlExceeded = true;
    }

    public void markHidingPoint() {
        if (!this.bestCandidates.isEmpty()) {
            this.isCollectingHidden = true;
        }
    }

    void accumulate(ResolutionResult result) {
        this.bestCandidates.addAll(result.getBestCandidates());
        this.hiddenCandidates.addAll(result.getHiddenCandidates());
    }

    public ResolutionResult<ModelicaType> getTypes() {
        return new Result<ModelicaType>(ModelicaType.class, this.bestCandidates, this.hiddenCandidates, this.ttlExceeded);
    }

    public ResolutionResult<ModelicaDeclaration> getDeclaration() {
        return new Result<ModelicaDeclaration>(ModelicaDeclaration.class, this.bestCandidates, this.hiddenCandidates, this.ttlExceeded);
    }

    public <T extends ResolvableEntity> ResolutionResult<T> get(Class<T> clazz) {
        return new Result<T>(clazz, this.bestCandidates, this.hiddenCandidates, this.ttlExceeded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Resolved[");
        sb.append(this.bestCandidates.size());
        sb.append('/');
        sb.append(this.hiddenCandidates.size());
        sb.append(']');
        return sb.toString();
    }

    private static class Result<A extends ResolvableEntity>
    implements ResolutionResult<A> {
        private final List<A> bestCandidates = new ArrayList<A>();
        private final List<A> hiddenCandidates = new ArrayList<A>();
        private final boolean timedOut;

        Result(Class<A> tpe, List<?> best, List<?> hidden, boolean timedOut) {
            for (Object b : best) {
                if (!tpe.isInstance(b)) continue;
                this.bestCandidates.add((ResolvableEntity)b);
            }
            for (Object h : hidden) {
                if (!tpe.isInstance(h)) continue;
                this.hiddenCandidates.add((ResolvableEntity)h);
            }
            this.timedOut = timedOut;
        }

        @Override
        public List<A> getBestCandidates() {
            return Collections.unmodifiableList(this.bestCandidates);
        }

        @Override
        public List<A> getHiddenCandidates() {
            return Collections.unmodifiableList(this.hiddenCandidates);
        }

        @Override
        public boolean isUnresolved() {
            return this.bestCandidates.isEmpty();
        }

        @Override
        public boolean isClashed() {
            return this.bestCandidates.size() > 1;
        }

        @Override
        public boolean hasHiddenResults() {
            return !this.hiddenCandidates.isEmpty();
        }

        @Override
        public boolean wasTimedOut() {
            return this.timedOut;
        }
    }
}

