/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.resolver.RootScope;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

abstract class AbstractModelicaScope
implements ModelicaScope {
    private AbstractModelicaScope parent;
    private final List<ModelicaDeclaration> declarations = new ArrayList<ModelicaDeclaration>();
    private final Map<String, List<ModelicaDeclaration>> declarationsByName = new HashMap<String, List<ModelicaDeclaration>>();

    AbstractModelicaScope() {
    }

    void setParent(AbstractModelicaScope scope) {
        this.parent = scope;
    }

    @Override
    public ModelicaScope getParent() {
        return this.parent;
    }

    void addDeclaration(ModelicaDeclaration declaration) {
        String name = declaration.getSimpleDeclarationName();
        this.declarations.add(declaration);
        if (!this.declarationsByName.containsKey(name)) {
            this.declarationsByName.put(name, new ArrayList());
        }
        this.declarationsByName.get(name).add(declaration);
    }

    @Override
    public List<ModelicaDeclaration> getContainedDeclarations() {
        return Collections.unmodifiableList(this.declarations);
    }

    List<ModelicaDeclaration> getDirectlyDeclared(String simpleName) {
        List<ModelicaDeclaration> result = this.declarationsByName.get(simpleName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    abstract void resolveLexically(ResolutionContext var1, CompositeName var2) throws Watchdog.CountdownException;

    @Override
    public <T extends ResolvableEntity> ResolutionResult<T> safeResolveLexically(Class<T> clazz, ResolutionState state, CompositeName name) {
        ResolutionContext result = state.createContext();
        try {
            this.resolveLexically(result, name);
        }
        catch (Watchdog.CountdownException e) {
            result.markTtlExceeded();
        }
        return result.get(clazz);
    }

    protected abstract String getRepresentation();

    String getNestingRepresentation() {
        ModelicaScope parentScope = this.getParent();
        String prefix = "";
        if (parentScope != null) {
            prefix = ((AbstractModelicaScope)parentScope).getNestingRepresentation();
        }
        return prefix + "#" + this.getRepresentation();
    }

    @Override
    public RootScope getRoot() {
        return this.getParent().getRoot();
    }

    public String toString() {
        return this.getRepresentation();
    }
}

