/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.ast;

import net.sourceforge.pmd.lang.modelica.ast.ASTSimpleName;
import net.sourceforge.pmd.lang.modelica.ast.AbstractModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.Helper;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaVisitor;
import net.sourceforge.pmd.lang.modelica.ast.ResolvableModelicaNode;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;

public final class ASTName
extends AbstractModelicaNode
implements ResolvableModelicaNode {
    private String[] nameComponents;
    private ResolutionResult<ResolvableEntity> resolutionCandidates;
    private boolean absolute = false;

    ASTName(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptModelicaVisitor(ModelicaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public void jjtClose() {
        int i;
        super.jjtClose();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.getNumChildren(); ++i) {
            if (i != 0 || this.absolute) {
                sb.append('.');
            }
            sb.append(((ASTSimpleName)this.getChild(i)).getImage());
        }
        this.setImage(sb.toString());
        this.nameComponents = new String[this.getNumChildren()];
        for (i = 0; i < this.getNumChildren(); ++i) {
            this.nameComponents[i] = ((ModelicaNode)this.getChild(i)).getImage();
        }
    }

    void markAbsolute() {
        this.absolute = true;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public CompositeName getCompositeName() {
        return CompositeName.create(this.absolute, this.nameComponents);
    }

    @Override
    public ResolutionResult<ResolvableEntity> getResolutionCandidates() {
        if (this.resolutionCandidates == null) {
            this.resolutionCandidates = this.getMostSpecificScope().safeResolveLexically(ResolvableEntity.class, ResolutionState.forType(), this.getCompositeName());
        }
        return this.resolutionCandidates;
    }

    public String getResolvedTo() {
        return Helper.getResolvedTo(this.getResolutionCandidates());
    }
}

