/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTAstRoot;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptTreeBuilder;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ErrorCollector;
import org.mozilla.javascript.ast.ParseProblem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EcmascriptParser
implements net.sourceforge.pmd.lang.ast.Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(EcmascriptParser.class);
    private final LanguagePropertyBundle properties;

    public EcmascriptParser(LanguagePropertyBundle properties) {
        this.properties = properties;
    }

    private AstRoot parseEcmascript(FileId fileId, String sourceCode, LanguageVersion version, List<ParseProblem> parseProblems) throws ParseException {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setRecordingComments(true);
        compilerEnvirons.setRecordingLocalJsDocComments(true);
        compilerEnvirons.setLanguageVersion(EcmascriptParser.determineRhinoLanguageVersion(version));
        compilerEnvirons.setIdeMode(true);
        compilerEnvirons.setWarnTrailingComma(true);
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        ErrorCollector errorCollector = new ErrorCollector();
        Parser parser = new Parser(compilerEnvirons, (ErrorReporter)errorCollector);
        String sourceURI = fileId.getOriginalPath();
        boolean beginLineno = true;
        AstRoot astRoot = parser.parse(sourceCode, sourceURI, 1);
        parseProblems.addAll(errorCollector.getErrors());
        return astRoot;
    }

    private static int determineRhinoLanguageVersion(LanguageVersion version) {
        switch (version.getVersion()) {
            case "3": {
                return 150;
            }
            case "5": {
                return 180;
            }
        }
        return 200;
    }

    public RootNode parse(Parser.ParserTask task) throws FileAnalysisException {
        LanguageVersion version = task.getLanguageVersion();
        ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
        AstRoot astRoot = this.parseEcmascript(task.getFileId(), task.getSourceText(), version, parseProblems);
        List errors = parseProblems.stream().filter(p -> p.getType() == ParseProblem.Type.Error).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            String errorMessage = errors.stream().map(p -> {
                TextPos2d textPos2d = task.getTextDocument().lineColumnAtOffset(p.getFileOffset());
                FileLocation caret = FileLocation.caret((FileId)task.getFileId(), (int)textPos2d.getLine(), (int)textPos2d.getColumn());
                return caret.startPosToStringWithFile() + ": " + p.getMessage();
            }).collect(Collectors.joining(System.lineSeparator()));
            LOGGER.warn("{} javascript problems found:{}{}", new Object[]{errors.size(), System.lineSeparator(), errorMessage});
        }
        EcmascriptTreeBuilder treeBuilder = new EcmascriptTreeBuilder(parseProblems);
        ASTAstRoot tree = (ASTAstRoot)treeBuilder.build(astRoot);
        String suppressMarker = this.properties.getSuppressMarker();
        HashMap<Integer, String> suppressMap = new HashMap<Integer, String>();
        if (astRoot.getComments() != null) {
            for (Comment comment : astRoot.getComments()) {
                int nopmd = comment.getValue().indexOf(suppressMarker);
                if (nopmd <= -1) continue;
                String suppression = comment.getValue().substring(nopmd + suppressMarker.length());
                suppressMap.put(comment.getLineno(), suppression);
            }
        }
        tree.setAstInfo((AstInfo<ASTAstRoot>)new AstInfo(task, (RootNode)tree).withSuppressMap(suppressMap));
        return tree;
    }
}

