/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.reporting.RuleContext;

public class OverrideBothEqualsAndHashcodeRule
extends AbstractJavaRulechainRule {
    public OverrideBothEqualsAndHashcodeRule() {
        super(ASTClassDeclaration.class, ASTRecordDeclaration.class, ASTAnonymousClassDeclaration.class);
    }

    protected boolean skipType(ASTTypeDeclaration node) {
        return TypeTestUtil.isA(Comparable.class, (TypeNode)node);
    }

    private void visitTypeDecl(ASTTypeDeclaration node, Object data) {
        if (this.skipType(node)) {
            return;
        }
        ASTMethodDeclaration equalsMethod = null;
        ASTMethodDeclaration hashCodeMethod = null;
        for (ASTMethodDeclaration m : node.getDeclarations(ASTMethodDeclaration.class)) {
            if (JavaAstUtils.isEqualsMethod(m)) {
                equalsMethod = m;
                if (hashCodeMethod == null) continue;
                break;
            }
            if (!JavaAstUtils.isHashCodeMethod(m)) continue;
            hashCodeMethod = m;
            if (equalsMethod == null) continue;
            break;
        }
        this.maybeReport(this.asCtx(data), node, hashCodeMethod, equalsMethod);
    }

    protected void maybeReport(RuleContext ctx, ASTTypeDeclaration node, ASTMethodDeclaration hashCodeMethod, ASTMethodDeclaration equalsMethod) {
        if (hashCodeMethod != null ^ equalsMethod != null) {
            ASTMethodDeclaration nonNullNode = equalsMethod == null ? hashCodeMethod : equalsMethod;
            ctx.addViolation((Node)nonNullNode);
        }
    }

    public Object visit(ASTAnonymousClassDeclaration node, Object data) {
        this.visitTypeDecl(node, data);
        return null;
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (node.isInterface()) {
            return null;
        }
        this.visitTypeDecl(node, data);
        return null;
    }

    public Object visit(ASTRecordDeclaration node, Object data) {
        this.visitTypeDecl(node, data);
        return null;
    }
}

