/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.rule.internal.AbstractJavaCounterCheckRule;

public class ExcessiveParameterListRule
extends AbstractJavaCounterCheckRule<ASTFormalParameters> {
    public ExcessiveParameterListRule() {
        super(ASTFormalParameters.class);
    }

    @Override
    protected int defaultReportLevel() {
        return 10;
    }

    @Override
    protected boolean isIgnored(ASTFormalParameters node) {
        return this.areParametersOfPrivateConstructor(node);
    }

    private boolean areParametersOfPrivateConstructor(ASTFormalParameters params) {
        Node parent = params.getParent();
        return parent instanceof ASTConstructorDeclaration && ((ASTConstructorDeclaration)parent).getVisibility() == ModifierOwner.Visibility.V_PRIVATE;
    }

    @Deprecated
    protected boolean isViolation(ASTFormalParameters node, int reportLevel) {
        throw new UnsupportedOperationException("method is deprecated and not supported anymore.");
    }

    @Override
    protected int getMetric(ASTFormalParameters node) {
        return node.size();
    }
}

