/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.util.OptionalBool;

public class IdenticalCatchBranchesRule
extends AbstractJavaRulechainRule {
    public IdenticalCatchBranchesRule() {
        super(ASTTryStatement.class, new Class[0]);
    }

    private boolean areEquivalent(ASTCatchClause st1, ASTCatchClause st2) {
        String e1Name = st1.getParameter().getName();
        String e2Name = st2.getParameter().getName();
        return JavaAstUtils.tokenEquals(st1.getBody(), st2.getBody(), name -> name.equals(e1Name) ? e2Name : name) && IdenticalCatchBranchesRule.areStructurallyEquivalent(st1.getBody(), st2.getBody(), this::isSameMethod);
    }

    private OptionalBool isSameMethod(JavaNode n1, JavaNode n2) {
        if (n1 instanceof InvocationNode) {
            JMethodSig methodType2;
            JMethodSig methodType1 = ((InvocationNode)n1).getMethodType();
            return TypeOps.overrideSameMethod(methodType1, methodType2 = ((InvocationNode)n2).getMethodType()) ? OptionalBool.UNKNOWN : OptionalBool.NO;
        }
        return OptionalBool.UNKNOWN;
    }

    private static boolean areStructurallyEquivalent(JavaNode n1, JavaNode n2, PartialEquivalenceRel<JavaNode> areEquivalent) {
        if (n1.getNumChildren() != n2.getNumChildren() || !n1.getClass().equals(n2.getClass()) || areEquivalent.test(n1, n2) == OptionalBool.NO) {
            return false;
        }
        for (int i = 0; i < n1.getNumChildren(); ++i) {
            if (IdenticalCatchBranchesRule.areStructurallyEquivalent((JavaNode)n1.getChild(i), (JavaNode)n2.getChild(i), areEquivalent)) continue;
            return false;
        }
        return true;
    }

    private Set<List<ASTCatchClause>> equivalenceClasses(List<ASTCatchClause> catches) {
        HashSet<List<ASTCatchClause>> result = new HashSet<List<ASTCatchClause>>(catches.size());
        for (ASTCatchClause stmt : catches) {
            if (result.isEmpty()) {
                result.add(this.newEquivClass(stmt));
                continue;
            }
            boolean isNewClass = true;
            for (List list : result) {
                if (!this.areEquivalent(stmt, (ASTCatchClause)list.get(0))) continue;
                list.add(stmt);
                isNewClass = false;
                break;
            }
            if (!isNewClass) continue;
            result.add(this.newEquivClass(stmt));
        }
        return result;
    }

    private List<ASTCatchClause> newEquivClass(ASTCatchClause stmt) {
        ArrayList<ASTCatchClause> result = new ArrayList<ASTCatchClause>(2);
        result.add(stmt);
        return result;
    }

    private String getCaughtExceptionsAsString(ASTCatchClause stmt) {
        return PrettyPrintingUtil.prettyPrintType(stmt.getParameter().getTypeNode());
    }

    public Object visit(ASTTryStatement node, Object data) {
        List catchStatements = node.getCatchClauses().toList();
        Set<List<ASTCatchClause>> equivClasses = this.equivalenceClasses(catchStatements);
        for (List<ASTCatchClause> identicalStmts : equivClasses) {
            if (identicalStmts.size() <= 1) continue;
            String identicalBranchName = this.getCaughtExceptionsAsString(identicalStmts.get(0));
            for (int i = 1; i < identicalStmts.size(); ++i) {
                this.asCtx(data).addViolation((Node)identicalStmts.get(i), new Object[]{identicalBranchName});
            }
        }
        return data;
    }

    static interface PartialEquivalenceRel<T> {
        public OptionalBool test(T var1, T var2);
    }
}

