/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPatternList;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnusedLocalVariableRule
extends AbstractJavaRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTLocalVariableDeclaration.class, (Class[])new Class[]{ASTTypePattern.class});
    }

    public Object visit(ASTLocalVariableDeclaration decl, Object data) {
        for (ASTVariableId varId : decl.getVarIds()) {
            if (!JavaAstUtils.isNeverUsed(varId) || JavaRuleUtil.isExplicitUnusedVarName(varId.getName())) continue;
            this.asCtx(data).addViolation((Node)varId, new Object[]{varId.getName()});
        }
        return data;
    }

    public Object visit(ASTTypePattern pattern, Object data) {
        ASTVariableId varId = pattern.getVarId();
        if (JavaAstUtils.isNeverUsed(varId) && !JavaRuleUtil.isExplicitUnusedVarName(varId.getName()) && !this.neededForSwitchOrRcord(pattern)) {
            this.asCtx(data).addViolation((Node)varId, new Object[]{varId.getName()});
        }
        return data;
    }

    private boolean neededForSwitchOrRcord(ASTTypePattern pattern) {
        JavaNode parent = (JavaNode)pattern.getParent();
        return (parent instanceof ASTSwitchLabel || parent instanceof ASTPatternList) && pattern.getLanguageVersion().compareToVersion("22") < 0;
    }
}

