/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavadocCommentOwner;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavadocComment
extends JavaComment {
    private JavadocCommentOwner owner;
    private final List<JavaccToken> tokens;

    JavadocComment(JavaccToken t) {
        super(t);
        assert (t.kind == 7 || JavaAstUtils.isMarkdownComment(t));
        this.tokens = Collections.emptyList();
    }

    JavadocComment(List<JavaComment> currentMarkdownBlock) {
        super(currentMarkdownBlock.get(0).getToken());
        assert (currentMarkdownBlock.stream().map(JavaComment::getToken).allMatch(JavaAstUtils::isMarkdownComment));
        this.tokens = currentMarkdownBlock.stream().map(JavaComment::getToken).collect(Collectors.toList());
    }

    @Override
    public Chars getText() {
        if (this.tokens.isEmpty()) {
            return super.getText();
        }
        StringBuilder markdownBlock = new StringBuilder(this.tokens.size() * 80);
        for (JavaccToken token : this.tokens) {
            token.getText().appendChars(markdownBlock);
        }
        return Chars.wrap((CharSequence)markdownBlock.toString());
    }

    @Override
    public FileLocation getReportLocation() {
        if (this.tokens.isEmpty()) {
            return super.getReportLocation();
        }
        JavaccToken firstToken = this.tokens.get(0);
        JavaccToken lastToken = this.tokens.get(this.tokens.size() - 1);
        TextRegion region = TextRegion.fromBothOffsets((int)firstToken.getRegion().getStartOffset(), (int)lastToken.getRegion().getEndOffset());
        return firstToken.getDocument().getTextDocument().toLocation(region);
    }

    @Override
    public boolean isSingleLine() {
        if (this.tokens.isEmpty()) {
            return super.isSingleLine();
        }
        return this.tokens.size() == 1;
    }

    void setOwner(JavadocCommentOwner owner) {
        this.owner = owner;
    }

    public @Nullable JavadocCommentOwner getOwner() {
        return this.owner;
    }
}

