/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collection;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum JModifier {
    PUBLIC(1),
    PROTECTED(4),
    PRIVATE(2),
    ABSTRACT(1024),
    DEFAULT(0),
    STATIC(8),
    FINAL(16),
    SEALED(0),
    NON_SEALED("non-sealed", 0),
    TRANSIENT(128),
    VOLATILE(64),
    SYNCHRONIZED(32),
    NATIVE(256),
    STRICTFP(2048);

    private final String token;
    private final int reflect;

    private JModifier(int reflect) {
        this.token = this.name().toLowerCase(Locale.ROOT);
        this.reflect = reflect;
    }

    private JModifier(String token, int reflect) {
        this.token = token;
        this.reflect = reflect;
    }

    public int getReflectMod() {
        return this.reflect;
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        return this.getToken();
    }

    public static int toReflect(Collection<JModifier> mods) {
        int res = 0;
        for (JModifier mod : mods) {
            res |= mod.getReflectMod();
        }
        return res;
    }

    public static @NonNull JModifier fromToken(@NonNull String token) {
        return JModifier.valueOf(token.toLowerCase(Locale.ROOT));
    }
}

