/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.ast.internal;

import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InvocCtx
extends ExprContext {
    private final int arg;
    private final InvocationNode node;

    public InvocCtx(int arg, InvocationNode node) {
        super(ExprContext.ExprContextKind.INVOCATION);
        this.arg = arg;
        this.node = node;
    }

    @Override
    public @Nullable JTypeMirror getTargetType() {
        OverloadSelectionResult overload = this.node.getOverloadSelectionInfo();
        if (overload.isFailed()) {
            return null;
        }
        return overload.ithFormalParam(this.arg);
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    public InvocationNode getNode() {
        return this.node;
    }

    public String toString() {
        return "InvocCtx{arg=" + this.arg + ", node=" + this.node + '}';
    }
}

