/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;

public class UnnecessaryVarargsArrayCreationRule
extends AbstractJavaRulechainRule {
    public UnnecessaryVarargsArrayCreationRule() {
        super(ASTArrayAllocation.class, new Class[0]);
    }

    public Object visit(ASTArrayAllocation array, Object data) {
        if (array.getArrayInitializer() == null) {
            return null;
        }
        JavaNode parent = (JavaNode)array.getParent();
        if (parent instanceof ASTArgumentList && array.getIndexInParent() == parent.getNumChildren() - 1) {
            InvocationNode call = (InvocationNode)parent.getParent();
            OverloadSelectionResult info = call.getOverloadSelectionInfo();
            if (info.isFailed() || info.isVarargsCall() || !info.getMethodType().isVarargs()) {
                return null;
            }
            List<JTypeMirror> formals = info.getMethodType().getFormalParameters();
            JTypeMirror lastFormal = formals.get(formals.size() - 1);
            if (array.getTypeMirror().equals(lastFormal)) {
                this.asCtx(data).addViolation((Node)array);
            }
        }
        return null;
    }
}

