/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BigIntegerInstantiationRule
extends AbstractJavaRulechainRule {
    private static final Set<String> BIGDECIMAL_CONSTANTS = CollectionUtil.setOf((Object)"0", (Object[])new String[]{"0.", "1", "10"});

    public BigIntegerInstantiationRule() {
        super(ASTConstructorCall.class, new Class[0]);
    }

    public Object visit(ASTConstructorCall node, Object data) {
        boolean java19;
        LanguageVersion languageVersion = node.getTextDocument().getLanguageVersion();
        @NonNull ASTArgumentList arguments = node.getArguments();
        if (arguments.size() != 1) {
            return data;
        }
        Object constValue = ((ASTExpression)arguments.get(0)).getConstValue();
        boolean java5 = languageVersion.compareToVersion("1.5") >= 0;
        boolean java9 = languageVersion.compareToVersion("9") >= 0;
        boolean bl = java19 = languageVersion.compareToVersion("19") >= 0;
        if (TypeTestUtil.isA(BigInteger.class, (TypeNode)node)) {
            if ("0".equals(constValue) || "1".equals(constValue)) {
                this.asCtx(data).addViolation((Node)node);
            }
            if (java5 && "10".equals(constValue)) {
                this.asCtx(data).addViolation((Node)node);
            }
            if (java9 && "2".equals(constValue)) {
                this.asCtx(data).addViolation((Node)node);
            }
        } else if (TypeTestUtil.isA(BigDecimal.class, (TypeNode)node)) {
            if (java5 && BIGDECIMAL_CONSTANTS.contains(String.valueOf(constValue))) {
                this.asCtx(data).addViolation((Node)node);
            }
            if (java19 && "2".equals(String.valueOf(constValue))) {
                this.asCtx(data).addViolation((Node)node);
            }
        }
        return data;
    }
}

