/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */

package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import org.checkerframework.checker.nullness.qual.Nullable;

import net.sourceforge.pmd.lang.java.ast.FunctionalExpression;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror.FunctionalExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors.MirrorMaker;

/**
 *
 */
abstract class BaseFunctionalMirror<N extends FunctionalExpression> extends BasePolyMirror<N> implements FunctionalExprMirror {
    private JMethodSig inferredMethod;

    BaseFunctionalMirror(JavaExprMirrors mirrors, N myNode, @Nullable ExprMirror parent, MirrorMaker subexprMaker) {
        super(mirrors, myNode, parent, subexprMaker);
    }

    @Override
    public void setFunctionalMethod(JMethodSig methodType) {
        this.inferredMethod = methodType;
        if (mayMutateAst()) {
            InternalApiBridge.setFunctionalMethod(myNode, methodType);
        }
    }

    protected JMethodSig getInferredMethod() {
        return inferredMethod;
    }

    @Override
    public void finishFailedInference(@Nullable JTypeMirror targetType) {
        setInferredType(targetType == null ? factory.ts.UNKNOWN : targetType);
        setFunctionalMethod(factory.ts.UNRESOLVED_METHOD);
    }
}
