/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;

final class SupertypeCheckCache {
    private final Map<JTypeMirror, Set<JTypeMirror>> cache = new LinkedHashMap<JTypeMirror, Set<JTypeMirror>>(){
        private static final int MAX_SIZE = 50;

        @Override
        protected boolean removeEldestEntry(Map.Entry<JTypeMirror, Set<JTypeMirror>> eldest) {
            return this.size() > 50;
        }
    };

    SupertypeCheckCache() {
    }

    boolean isCertainlyASubtype(JTypeMirror t, JTypeMirror s) {
        Set<JTypeMirror> superTypesOfT = this.cache.get(t);
        return superTypesOfT != null && superTypesOfT.contains(s);
    }

    void remember(JTypeMirror t, JTypeMirror s) {
        if (this.shouldCache(t) && this.shouldCache(s)) {
            this.cache.computeIfAbsent(t, k -> new HashSet()).add(s);
        }
    }

    private boolean shouldCache(JTypeMirror t) {
        return !(t instanceof InferenceVar) && !(t instanceof JPrimitiveType);
    }
}

