/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.ArrayMethodSigImpl;
import net.sourceforge.pmd.lang.java.types.ArraySymbolImpl;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public final class JArrayType
implements JTypeMirror {
    private final JTypeMirror component;
    private final TypeSystem ts;
    private final PSet<SymbolicValue.SymAnnot> typeAnnots;
    private JClassSymbol symbol;

    JArrayType(TypeSystem ts, JTypeMirror component) {
        this(ts, component, null, (PSet<SymbolicValue.SymAnnot>)HashTreePSet.empty());
    }

    JArrayType(TypeSystem ts, JTypeMirror component, JClassSymbol arraySymbol, PSet<SymbolicValue.SymAnnot> typeAnnots) {
        assert (component != null) : "Expected non-null component";
        assert (typeAnnots != null) : "Expected non-null annotations";
        this.component = component;
        this.ts = ts;
        this.symbol = arraySymbol;
        this.typeAnnots = typeAnnots;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public @NonNull JClassSymbol getSymbol() {
        if (this.symbol == null) {
            JTypeDeclSymbol comp = this.getComponentType().getSymbol();
            if (comp == null) {
                comp = this.getComponentType().getErasure().getSymbol();
            }
            this.symbol = new ArraySymbolImpl(this.ts, comp);
        }
        return this.symbol;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return this.typeAnnots;
    }

    @Override
    public JArrayType withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        if (newTypeAnnots.isEmpty() && this.typeAnnots.isEmpty()) {
            return this;
        }
        return new JArrayType(this.ts, this.component, this.symbol, newTypeAnnots);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public JArrayType getErasure() {
        JTypeMirror erasedComp = this.component.getErasure();
        return erasedComp == this.component ? this : new JArrayType(this.ts, erasedComp, this.symbol, this.typeAnnots);
    }

    public JTypeMirror getComponentType() {
        return this.component;
    }

    public JTypeMirror getElementType() {
        JTypeMirror c = this;
        while (c instanceof JArrayType) {
            c = c.getComponentType();
        }
        return c;
    }

    @Override
    public Stream<JMethodSig> streamMethods(Predicate<? super JMethodSymbol> prefilter) {
        return Stream.concat(this.streamDeclaredMethods(prefilter), this.ts.OBJECT.streamMethods(prefilter));
    }

    @Override
    public Stream<JMethodSig> streamDeclaredMethods(Predicate<? super JMethodSymbol> prefilter) {
        return this.getSymbol().getDeclaredMethods().stream().filter(prefilter).map(it -> new ArrayMethodSigImpl(this, (JExecutableSymbol)it));
    }

    @Override
    public List<JMethodSig> getConstructors() {
        return CollectionUtil.map(this.getSymbol().getConstructors(), it -> new ArrayMethodSigImpl(this, (JExecutableSymbol)it));
    }

    @Override
    public boolean isRaw() {
        return this.getElementType().isRaw();
    }

    @Override
    public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitArray(this, p);
    }

    @Override
    public JArrayType subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        JTypeVisitable newComp = this.getComponentType().subst((Function)subst);
        return newComp == this.component ? this : this.getTypeSystem().arrayType((JTypeMirror)newComp).withAnnotations((PSet)this.getTypeAnnotations());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JArrayType)) {
            return false;
        }
        JArrayType that = (JArrayType)o;
        return TypeOps.isSameType(this, that);
    }

    public int hashCode() {
        return this.component.hashCode() * 3;
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }
}

