/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.util.Collection;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTPatternExpression;
import net.sourceforge.pmd.lang.java.ast.ASTRecordPattern;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.util.AssertionUtil;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

final class PatternBindingsUtil {
    private PatternBindingsUtil() {
    }

    static BindSet bindersOfExpr(ASTExpression e) {
        if (e instanceof ASTUnaryExpression) {
            ASTUnaryExpression unary = (ASTUnaryExpression)e;
            return unary.getOperator() == UnaryOp.NEGATION ? PatternBindingsUtil.bindersOfExpr(unary.getOperand()).negate() : BindSet.EMPTY;
        }
        if (e instanceof ASTInfixExpression) {
            BinaryOp op = ((ASTInfixExpression)e).getOperator();
            ASTExpression left = ((ASTInfixExpression)e).getLeftOperand();
            ASTExpression right = ((ASTInfixExpression)e).getRightOperand();
            if (op == BinaryOp.INSTANCEOF && right instanceof ASTPatternExpression) {
                return PatternBindingsUtil.bindersOfPattern(((ASTPatternExpression)right).getPattern());
            }
            if (op == BinaryOp.CONDITIONAL_AND) {
                return BindSet.whenTrue((PSet<ASTVariableDeclaratorId>)PatternBindingsUtil.bindersOfExpr(left).trueBindings.plusAll((Collection)PatternBindingsUtil.bindersOfExpr(right).trueBindings));
            }
            if (op == BinaryOp.CONDITIONAL_OR) {
                return BindSet.whenFalse((PSet<ASTVariableDeclaratorId>)PatternBindingsUtil.bindersOfExpr(left).falseBindings.plusAll((Collection)PatternBindingsUtil.bindersOfExpr(right).falseBindings));
            }
            return BindSet.EMPTY;
        }
        if (e instanceof ASTPatternExpression) {
            return PatternBindingsUtil.bindersOfPattern(((ASTPatternExpression)e).getPattern());
        }
        return BindSet.EMPTY;
    }

    static BindSet bindersOfPattern(ASTPattern pattern) {
        if (pattern instanceof ASTTypePattern) {
            return BindSet.whenTrue((PSet<ASTVariableDeclaratorId>)HashTreePSet.singleton((Object)((ASTTypePattern)pattern).getVarId()));
        }
        if (pattern instanceof ASTRecordPattern) {
            ASTVariableDeclaratorId varId = ((ASTRecordPattern)pattern).getVarId();
            if (varId == null) {
                return BindSet.whenTrue(BindSet.noBindings());
            }
            return BindSet.whenTrue((PSet<ASTVariableDeclaratorId>)HashTreePSet.singleton((Object)varId));
        }
        throw AssertionUtil.shouldNotReachHere((String)("no other instances of pattern should exist: " + pattern));
    }

    static final class BindSet {
        static final BindSet EMPTY = new BindSet((PSet<ASTVariableDeclaratorId>)HashTreePSet.empty(), (PSet<ASTVariableDeclaratorId>)HashTreePSet.empty());
        private final PSet<ASTVariableDeclaratorId> trueBindings;
        private final PSet<ASTVariableDeclaratorId> falseBindings;

        public BindSet union(BindSet bindSet) {
            if (this.isEmpty()) {
                return bindSet;
            }
            if (bindSet.isEmpty()) {
                return this;
            }
            return new BindSet((PSet<ASTVariableDeclaratorId>)this.trueBindings.plusAll(bindSet.trueBindings), (PSet<ASTVariableDeclaratorId>)this.falseBindings.plusAll(bindSet.falseBindings));
        }

        static PSet<ASTVariableDeclaratorId> noBindings() {
            return HashTreePSet.empty();
        }

        BindSet(PSet<ASTVariableDeclaratorId> trueBindings, PSet<ASTVariableDeclaratorId> falseBindings) {
            this.trueBindings = trueBindings;
            this.falseBindings = falseBindings;
        }

        public PSet<ASTVariableDeclaratorId> getTrueBindings() {
            return this.trueBindings;
        }

        public PSet<ASTVariableDeclaratorId> getFalseBindings() {
            return this.falseBindings;
        }

        BindSet negate() {
            return this.isEmpty() ? this : new BindSet(this.falseBindings, this.trueBindings);
        }

        boolean isEmpty() {
            return this == EMPTY;
        }

        BindSet addBinding(ASTVariableDeclaratorId e) {
            return new BindSet((PSet<ASTVariableDeclaratorId>)this.trueBindings.plus((Object)e), this.falseBindings);
        }

        static BindSet whenTrue(PSet<ASTVariableDeclaratorId> bindings) {
            return new BindSet(bindings, (PSet<ASTVariableDeclaratorId>)HashTreePSet.empty());
        }

        static BindSet whenFalse(PSet<ASTVariableDeclaratorId> bindings) {
            return new BindSet((PSet<ASTVariableDeclaratorId>)HashTreePSet.empty(), bindings);
        }
    }
}

