/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.MostlySingularMultimap;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CoreResolvers {
    private CoreResolvers() {
    }

    public static <S> NameResolver<S> singleton(final String name, final S symbol) {
        final List<S> single = Collections.singletonList(symbol);
        return new NameResolver.SingleNameResolver<S>(){

            @Override
            public @NonNull List<S> resolveHere(String s) {
                return name.equals(s) ? single : Collections.emptyList();
            }

            @Override
            public @Nullable S resolveFirst(String simpleName) {
                return name.equals(simpleName) ? symbol : null;
            }

            @Override
            public @NonNull OptionalBool knows(String simpleName) {
                return OptionalBool.definitely((boolean)name.equals(simpleName));
            }

            @Override
            public String toString() {
                return "Single(" + symbol + ")";
            }
        };
    }

    static <S> NameResolver<S> multimapResolver(MostlySingularMultimap<String, S> symbols) {
        return new MultimapResolver<S>(symbols);
    }

    public static <S> NameResolver.SingleNameResolver<S> singularMapResolver(Map<String, S> singular) {
        return new SingularMapResolver(singular);
    }

    public static <S> EmptyResolver<S> emptyResolver() {
        return EmptyResolver.INSTANCE;
    }

    private static final class EmptyResolver<S>
    implements NameResolver.SingleNameResolver<S> {
        private static final EmptyResolver INSTANCE = new EmptyResolver();

        private EmptyResolver() {
        }

        @Override
        public @Nullable S resolveFirst(String simpleName) {
            return null;
        }

        @Override
        public @NonNull List<S> resolveHere(String simpleName) {
            return Collections.emptyList();
        }

        @Override
        public @NonNull OptionalBool knows(String simpleName) {
            return OptionalBool.NO;
        }

        @Override
        public boolean isDefinitelyEmpty() {
            return true;
        }

        @Override
        public String toString() {
            return "Empty";
        }
    }

    private static class MultimapResolver<S>
    implements NameResolver<S> {
        private final MostlySingularMultimap<String, S> map;

        MultimapResolver(MostlySingularMultimap<String, S> map) {
            this.map = map;
        }

        @Override
        public @NonNull List<S> resolveHere(String s) {
            return this.map.get(s);
        }

        @Override
        public @NonNull OptionalBool knows(String simpleName) {
            return OptionalBool.definitely((boolean)this.map.containsKey(simpleName));
        }

        @Override
        public boolean isDefinitelyEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public String toString() {
            return "Map(" + this.mapToString() + ")";
        }

        private String mapToString() {
            if (this.map.isEmpty()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder("{");
            this.map.processValuesOneByOne((k, v) -> sb.append(v).append(", "));
            return sb.substring(0, sb.length() - 2) + "}";
        }
    }

    private static final class SingularMapResolver<S>
    implements NameResolver.SingleNameResolver<S> {
        private final Map<String, S> map;

        private SingularMapResolver(Map<String, S> map) {
            this.map = map;
        }

        @Override
        public @Nullable S resolveFirst(String simpleName) {
            return this.map.get(simpleName);
        }

        @Override
        public boolean isDefinitelyEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public @NonNull OptionalBool knows(String simpleName) {
            return OptionalBool.definitely((boolean)this.map.containsKey(simpleName));
        }

        @Override
        public String toString() {
            return "SingularMap(" + this.map.values() + ")";
        }
    }
}

