/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.TypeParamOwnerNode;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AbstractAstAnnotableSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymFactory;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstTypeParamSym;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractAstTParamOwner<T extends TypeParamOwnerNode & AccessNode>
extends AbstractAstAnnotableSym<T>
implements JTypeParameterOwnerSymbol {
    private final List<JTypeVar> tparams;
    private final int modifiers;

    AbstractAstTParamOwner(T node, AstSymFactory factory) {
        super(node, factory);
        this.modifiers = JModifier.toReflect(((AccessNode)node).getModifiers().getEffectiveModifiers());
        this.tparams = Collections.unmodifiableList(CollectionUtil.map(ASTList.orEmpty(node.getTypeParameters()), it -> new AstTypeParamSym((ASTTypeParameter)it, factory, this).getTypeMirror()));
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        return this.tparams;
    }

    @Override
    public @NonNull String getPackageName() {
        return ((TypeParamOwnerNode)this.node).getRoot().getPackageName();
    }
}

