/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericSigBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeParamsParser;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeSigParser;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.LexicalScope;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

class SignatureParser {
    private final AsmSymbolResolver loader;

    SignatureParser(AsmSymbolResolver loader) {
        this.loader = loader;
    }

    TypeSystem getTypeSystem() {
        return this.loader.getTypeSystem();
    }

    public JTypeMirror parseFieldType(LexicalScope scope, String signature) {
        MyTypeBuilder b = new MyTypeBuilder(scope, signature);
        SignatureParser.parseFully(b, TypeSigParser::typeSignature);
        return b.pop();
    }

    public JTypeMirror parseTypeVarBound(LexicalScope scope, String boundSig) {
        MyTypeBuilder b = new MyTypeBuilder(scope, boundSig);
        SignatureParser.parseFully(b, TypeSigParser::typeVarBound);
        return b.pop();
    }

    public void parseClassSignature(GenericSigBase.LazyClassSignature type, String genericSig) {
        TypeSigParser.TypeScanner b = this.typeParamsWrapper(type, genericSig);
        SignatureParser.parseFully(b, TypeSigParser::classHeader);
        type.setSuperInterfaces(b.popList());
        type.setSuperClass((JClassType)b.pop());
    }

    public void parseMethodType(GenericSigBase.LazyMethodType type, String genericSig) {
        TypeSigParser.TypeScanner b = this.typeParamsWrapper(type, genericSig);
        SignatureParser.parseFully(b, TypeSigParser::methodType);
        type.setExceptionTypes(b.popList());
        type.setReturnType(b.pop());
        type.setParameterTypes(b.popList());
    }

    private TypeSigParser.TypeScanner typeParamsWrapper(GenericSigBase<?> owner, String sig) {
        if (TypeParamsParser.hasTypeParams(sig)) {
            TypeParamsParser.TypeParametersBuilder b = new TypeParamsParser.TypeParametersBuilder(owner, sig);
            int tparamsEnd = TypeParamsParser.typeParams(b.start, b);
            List<JTypeVar> sigTypeParams = b.getOwnerTypeParams();
            owner.setTypeParams(sigTypeParams);
            LexicalScope lexScope = owner.getEnclosingTypeParams().andThen(sigTypeParams);
            return new MyTypeBuilder(lexScope, b.chars, tparamsEnd, b.end);
        }
        owner.setTypeParams(CollectionUtil.emptyList());
        return new MyTypeBuilder(owner.getEnclosingTypeParams(), sig);
    }

    private static void parseFully(TypeSigParser.TypeScanner scanner, TypeSigParser.ParseFunction parser) {
        int endOffset = parser.parse(scanner.start, scanner);
        scanner.expectEoI(endOffset);
    }

    private class MyTypeBuilder
    extends TypeSigParser.TypeScanner {
        MyTypeBuilder(LexicalScope lexicalScope, String descriptor) {
            super(SignatureParser.this.getTypeSystem(), lexicalScope, descriptor);
        }

        MyTypeBuilder(LexicalScope lexicalScope, String chars, int start, int end) {
            super(SignatureParser.this.getTypeSystem(), lexicalScope, chars, start, end);
        }

        @Override
        public @NonNull JClassSymbol makeClassSymbol(String internalName, int observedArity) {
            return SignatureParser.this.loader.resolveFromInternalNameCannotFail(internalName, observedArity);
        }
    }
}

