/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.JAccessibleElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationOwner;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

abstract class MemberStubBase
implements JAccessibleElementSymbol,
AsmStub,
AnnotationOwner {
    private final ClassStub classStub;
    private final String simpleName;
    private final int accessFlags;
    private PSet<SymbolicValue.SymAnnot> annotations = HashTreePSet.empty();

    protected MemberStubBase(ClassStub classStub, String simpleName, int accessFlags) {
        this.classStub = classStub;
        this.simpleName = simpleName;
        this.accessFlags = accessFlags;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.classStub.getTypeSystem();
    }

    @Override
    public AsmSymbolResolver getResolver() {
        return this.classStub.getResolver();
    }

    @Override
    public int getModifiers() {
        return this.accessFlags;
    }

    @Override
    public @NonNull ClassStub getEnclosingClass() {
        return this.classStub;
    }

    @Override
    public void addAnnotation(SymbolicValue.SymAnnot annot) {
        this.annotations = this.annotations.plus((Object)annot);
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getDeclaredAnnotations() {
        return this.annotations;
    }
}

