/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.Collection;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class AvoidInstantiatingObjectsInLoopsRule
extends AbstractJavaRulechainRule {
    public AvoidInstantiatingObjectsInLoopsRule() {
        super(ASTConstructorCall.class, ASTArrayAllocation.class);
    }

    @Override
    public Object visit(ASTConstructorCall node, Object data) {
        this.checkNode(node, data);
        return data;
    }

    @Override
    public Object visit(ASTArrayAllocation node, Object data) {
        this.checkNode(node, data);
        return data;
    }

    private void checkNode(JavaNode node, Object data) {
        if (this.notInsideLoop((Node)node)) {
            return;
        }
        if (this.notAThrowStatement(node) && this.notAReturnStatement(node) && this.notBreakFollowing(node) && this.notArrayAssignment(node) && this.notCollectionAccess(node)) {
            this.addViolation(data, (Node)node);
        }
    }

    private boolean notArrayAssignment(JavaNode node) {
        JavaNode childOfAssignment = (JavaNode)node.ancestorsOrSelf().filter(n -> n.getParent() instanceof ASTAssignmentExpression).first();
        if (childOfAssignment != null && childOfAssignment.getIndexInParent() == 1) {
            GenericNode assignee = ((JavaNode)childOfAssignment.getParent()).getFirstChild();
            return !(assignee instanceof ASTArrayAccess);
        }
        return true;
    }

    private boolean notCollectionAccess(JavaNode node) {
        return node.ancestors(ASTArgumentList.class).filter(n -> n.getParent() instanceof ASTMethodCall).filter(n -> TypeTestUtil.isA(Collection.class, (TypeNode)((ASTMethodCall)n.getParent()).getQualifier())).isEmpty();
    }

    private boolean notBreakFollowing(JavaNode node) {
        JavaNode statement = (JavaNode)node.ancestors().filter(n -> n.getParent() instanceof ASTBlock).first();
        return statement == null || !(statement.getNextSibling() instanceof ASTBreakStatement);
    }

    private boolean notAThrowStatement(JavaNode node) {
        return !(node.getParent() instanceof ASTThrowStatement);
    }

    private boolean notAReturnStatement(JavaNode node) {
        return !(node.getParent() instanceof ASTReturnStatement);
    }

    private boolean notInsideLoop(Node node) {
        for (Node n = node; n != null; n = n.getParent()) {
            if (n instanceof ASTLoopStatement) {
                return false;
            }
            if (n instanceof ASTForInit) {
                n = n.getParent();
                continue;
            }
            if (!(n.getParent() instanceof ASTForeachStatement) || n.getParent().getNumChildren() <= 1 || n != n.getParent().getChild(1)) continue;
            n = n.getParent();
        }
        return true;
    }
}

