/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.text.Format;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnsynchronizedStaticFormatterRule
extends AbstractJavaRulechainRule {
    private static final List<String> THREAD_SAFE_FORMATTER = Arrays.asList("org.apache.commons.lang3.time.FastDateFormat");
    private static final PropertyDescriptor<Boolean> ALLOW_METHOD_LEVEL_SYNC = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowMethodLevelSynchronization").desc("If true, method level synchronization is allowed as well as synchronized block. Otherwise only synchronized blocks are allowed.")).defaultValue((Object)false)).build();
    private Class<?> formatterClassToCheck = Format.class;

    public UnsynchronizedStaticFormatterRule() {
        super(ASTFieldDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(ALLOW_METHOD_LEVEL_SYNC);
    }

    UnsynchronizedStaticFormatterRule(Class<?> formatterClassToCheck) {
        this();
        this.formatterClassToCheck = formatterClassToCheck;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (!node.hasModifiers(JModifier.STATIC, new JModifier[0])) {
            return data;
        }
        ASTClassOrInterfaceType cit = (ASTClassOrInterfaceType)node.descendants(ASTClassOrInterfaceType.class).first();
        if (cit == null || !TypeTestUtil.isA(this.formatterClassToCheck, (TypeNode)cit)) {
            return data;
        }
        ASTVariableDeclaratorId var = (ASTVariableDeclaratorId)node.descendants(ASTVariableDeclaratorId.class).first();
        for (String formatter : THREAD_SAFE_FORMATTER) {
            if (!TypeTestUtil.isA(formatter, (TypeNode)var)) continue;
            return data;
        }
        for (ASTAssignableExpr.ASTNamedReferenceExpr ref : var.getLocalUsages()) {
            ASTMethodDeclaration method;
            ASTExpression lockExpression;
            ASTMethodCall methodCall = null;
            if (ref.getParent() instanceof ASTMethodCall) {
                methodCall = (ASTMethodCall)ref.getParent();
            }
            if (methodCall == null) continue;
            ASTAssignableExpr.ASTNamedReferenceExpr n = ref;
            ASTSynchronizedStatement syncStatement = (ASTSynchronizedStatement)ref.ancestors(ASTSynchronizedStatement.class).first();
            if (syncStatement != null && JavaAstUtils.isReferenceToSameVar(lockExpression = syncStatement.getLockExpression(), methodCall.getQualifier()) || ((Boolean)this.getProperty(ALLOW_METHOD_LEVEL_SYNC)).booleanValue() && (method = (ASTMethodDeclaration)ref.ancestors(ASTMethodDeclaration.class).first()) != null && method.hasModifiers(JModifier.SYNCHRONIZED, new JModifier[]{JModifier.STATIC})) continue;
            this.addViolation(data, (Node)n);
        }
        return data;
    }
}

