/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ProperCloneImplementationRule
extends AbstractJavaRulechainRule {
    public ProperCloneImplementationRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        ASTAnyTypeDeclaration enclosingType;
        if (JavaAstUtils.isCloneMethod(method) && !method.isAbstract() && this.isNotFinal(enclosingType = method.getEnclosingType()) && this.hasAnyAllocationOfClass(method, enclosingType)) {
            this.addViolation(data, (Node)method);
        }
        return data;
    }

    private boolean isNotFinal(ASTAnyTypeDeclaration classOrInterfaceDecl) {
        return !classOrInterfaceDecl.hasModifiers(JModifier.FINAL, new JModifier[0]);
    }

    private boolean hasAnyAllocationOfClass(ASTMethodDeclaration method, ASTAnyTypeDeclaration enclosingType) {
        @NonNull JClassSymbol typeSymbol = enclosingType.getTypeMirror().getSymbol();
        return method.descendants(ASTConstructorCall.class).filter(ctor -> ctor.getTypeMirror().getSymbol().equals(typeSymbol)).nonEmpty();
    }
}

