/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class AvoidDuplicateLiteralsRule
extends AbstractJavaRulechainRule {
    public static final PropertyDescriptor<Integer> THRESHOLD_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxDuplicateLiterals").desc("Max duplicate literals")).require(NumericConstraints.positive())).defaultValue((Object)4)).build();
    public static final PropertyDescriptor<Integer> MINIMUM_LENGTH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"minimumLength").desc("Minimum string length to check")).require(NumericConstraints.positive())).defaultValue((Object)3)).build();
    public static final PropertyDescriptor<Boolean> SKIP_ANNOTATIONS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"skipAnnotations").desc("Skip literals within annotations")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<List<String>> EXCEPTION_LIST_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"exceptionList").desc("List of literals to ignore. A literal is ignored if its image can be found in this list. Components of this list should not be surrounded by double quotes.")).defaultValue(Collections.emptyList())).delim(',').build();
    private Map<String, SortedSet<ASTStringLiteral>> literals = new HashMap<String, SortedSet<ASTStringLiteral>>();
    private Set<String> exceptions = new HashSet<String>();
    private int minLength;

    public AvoidDuplicateLiteralsRule() {
        super(ASTStringLiteral.class, new Class[0]);
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
        this.definePropertyDescriptor(MINIMUM_LENGTH_DESCRIPTOR);
        this.definePropertyDescriptor(SKIP_ANNOTATIONS_DESCRIPTOR);
        this.definePropertyDescriptor(EXCEPTION_LIST_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        super.start(ctx);
        this.literals.clear();
        if (this.getProperty(EXCEPTION_LIST_DESCRIPTOR) != null) {
            this.exceptions = new HashSet<String>((Collection)this.getProperty(EXCEPTION_LIST_DESCRIPTOR));
        }
        this.minLength = 2 + (Integer)this.getProperty(MINIMUM_LENGTH_DESCRIPTOR);
    }

    public void end(RuleContext ctx) {
        this.processResults(ctx);
        super.end(ctx);
    }

    private void processResults(Object data) {
        int threshold = (Integer)this.getProperty(THRESHOLD_DESCRIPTOR);
        for (Map.Entry<String, SortedSet<ASTStringLiteral>> entry : this.literals.entrySet()) {
            SortedSet<ASTStringLiteral> occurrences = entry.getValue();
            if (occurrences.size() < threshold) continue;
            ASTStringLiteral first = occurrences.first();
            Object[] args = new Object[]{first.toPrintableString(), occurrences.size(), first.getBeginLine()};
            this.addViolation(data, (Node)first, args);
        }
    }

    @Override
    public Object visit(ASTStringLiteral node, Object data) {
        String image = node.getImage();
        if (image.length() < this.minLength) {
            return data;
        }
        if (this.exceptions.contains(image.substring(1, image.length() - 1))) {
            return data;
        }
        if (((Boolean)this.getProperty(SKIP_ANNOTATIONS_DESCRIPTOR)).booleanValue() && node.ancestors(ASTAnnotation.class).nonEmpty()) {
            return data;
        }
        SortedSet occurrences = this.literals.computeIfAbsent(image, key -> new TreeSet(Node.COORDS_COMPARATOR));
        occurrences.add(node);
        return data;
    }
}

