/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.internal.AbstractJavaCounterCheckRule;

public class ExcessiveParameterListRule
extends AbstractJavaCounterCheckRule<ASTFormalParameters> {
    public ExcessiveParameterListRule() {
        super(ASTFormalParameters.class);
    }

    @Override
    protected int defaultReportLevel() {
        return 10;
    }

    @Override
    protected boolean isIgnored(ASTFormalParameters node) {
        return this.areParametersOfPrivateConstructor(node);
    }

    private boolean areParametersOfPrivateConstructor(ASTFormalParameters params) {
        Node parent = params.getParent();
        return parent instanceof ASTConstructorDeclaration && ((ASTConstructorDeclaration)parent).getVisibility() == AccessNode.Visibility.V_PRIVATE;
    }

    @Override
    protected boolean isViolation(ASTFormalParameters node, int reportLevel) {
        return node.size() > reportLevel;
    }
}

